/*
 * Decompiled with CFR 0.152.
 */
package fuzs.metalbundles.data.client;

import com.google.gson.JsonElement;
import fuzs.metalbundles.client.MetalBundlesClient;
import fuzs.metalbundles.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.ItemModelProperties;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public void addItemModels(ItemModelGenerators builder) {
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.LEATHER_BUNDLE_ITEM.value(), Items.BUNDLE);
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.COPPER_BUNDLE_ITEM.value());
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.IRON_BUNDLE_ITEM.value());
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.GOLDEN_BUNDLE_ITEM.value());
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.DIAMOND_BUNDLE_ITEM.value());
        ModModelProvider.createMetalBundleItem(builder, (Item)ModRegistry.NETHERITE_BUNDLE_ITEM.value());
    }

    private static void createMetalBundleItem(ItemModelGenerators builder, Item item) {
        ModModelProvider.createMetalBundleItem(builder, item, item);
    }

    private static void createMetalBundleItem(ItemModelGenerators builder, Item item, Item modelItem) {
        ResourceLocation modelLocation = ModModelProvider.generateFlatItem(ModModelProvider.getLocation(item, "_filled"), ModModelProvider.getLocation(modelItem, "_filled"), ModelTemplates.FLAT_ITEM, builder.output);
        ItemModelProperties itemModelProperties = ItemModelProperties.singleOverride((ResourceLocation)modelLocation, (ResourceLocation)MetalBundlesClient.ITEM_MODEL_PROPERTY_FILLED, (float)1.0f);
        ModModelProvider.generateFlatItem(item, modelItem, ModelTemplates.FLAT_ITEM, (BiConsumer<ResourceLocation, Supplier<JsonElement>>)builder.output, ItemModelProperties.overridesFactory((ModelTemplate)ModelTemplates.FLAT_ITEM, (ItemModelProperties[])new ItemModelProperties[]{itemModelProperties}));
    }

    public static ResourceLocation getLocation(Block block, String modelLocationSuffix) {
        return ModModelProvider.getLocation((Block)block).withSuffix(modelLocationSuffix);
    }

    public static ResourceLocation getLocation(Item item, String modelLocationSuffix) {
        return ModModelProvider.getLocation((Item)item).withSuffix(modelLocationSuffix);
    }

    public static ResourceLocation generateFlatItem(ResourceLocation resourceLocation, ResourceLocation modelLocation, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        return modelTemplate.create(ModModelProvider.decorateItemModelLocation((ResourceLocation)resourceLocation), TextureMapping.layer0((ResourceLocation)ModModelProvider.decorateItemModelLocation((ResourceLocation)modelLocation)), modelOutput);
    }

    public static ResourceLocation generateFlatItem(Item item, Item modelItem, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, ModelTemplate.JsonFactory factory) {
        return ModModelProvider.generateFlatItem(item, TextureMapping.getItemTexture((Item)modelItem), modelTemplate, modelOutput, factory);
    }

    public static ResourceLocation generateFlatItem(Item item, ResourceLocation modelLocation, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, ModelTemplate.JsonFactory factory) {
        return modelTemplate.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((ResourceLocation)modelLocation), modelOutput, factory);
    }
}

