/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.wixie;

import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.ShapedHelper;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class WaterMilkRecipeWrapper
extends MultiRecipeWrapper {
    public static Map<RecipeCacheKey, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<RecipeCacheKey, MultiRecipeWrapper>();
    public boolean needMilk = false;
    public boolean needWater = false;

    public static MultiRecipeWrapper fromStack(ItemStack stack, Level level, boolean hasMilk, boolean hasWater) {
        WaterMilkRecipeWrapper wrapper = new WaterMilkRecipeWrapper();
        RecipeCacheKey key = new RecipeCacheKey(stack.getItem(), hasMilk, hasWater);
        if (RECIPE_CACHE.containsKey(key)) {
            return RECIPE_CACHE.get(key);
        }
        if (level.getServer() == null) {
            return wrapper;
        }
        for (RecipeHolder rh : level.getServer().getRecipeManager().getRecipes()) {
            Recipe r = rh.value();
            if (r.getResultItem((HolderLookup.Provider)level.registryAccess()) == null || r.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() != stack.getItem()) continue;
            if (r instanceof ShapedRecipe) {
                ShapedHelper helper = new ShapedHelper((ShapedRecipe)r);
                for (List iList : helper.getPossibleRecipes()) {
                    WaterMilkRecipeWrapper.removeMilkWater(level, hasMilk, hasWater, wrapper, r, iList);
                }
            }
            if (!(r instanceof ShapelessRecipe)) continue;
            NonNullList ingredients = r.getIngredients();
            WaterMilkRecipeWrapper.removeMilkWater(level, hasMilk, hasWater, wrapper, r, (List<Ingredient>)ingredients);
        }
        RECIPE_CACHE.put(key, wrapper);
        return wrapper;
    }

    private static void removeMilkWater(Level level, boolean hasMilk, boolean hasWater, WaterMilkRecipeWrapper wrapper, Recipe<?> r, List<Ingredient> ingredients) {
        boolean needMilk = false;
        boolean needWater = false;
        if (hasMilk) {
            needMilk = ingredients.removeIf(i -> i.test(Items.MILK_BUCKET.getDefaultInstance()));
        }
        if (hasWater) {
            needWater = ingredients.removeIf(i -> i.test(Items.WATER_BUCKET.getDefaultInstance()) || i.test(PotionUtil.getPotion((Holder)Potions.WATER)));
        }
        wrapper.addRecipe(ingredients, r.getResultItem((HolderLookup.Provider)level.registryAccess()), r, needWater, needMilk);
    }

    public boolean addRecipe(List<Ingredient> recipe, ItemStack outputStack, Recipe<?> iRecipe, boolean needWater, boolean needMilk) {
        this.needMilk = this.needMilk || needMilk;
        this.needWater = this.needWater || needWater;
        return super.addRecipe(recipe, outputStack, iRecipe);
    }

    public record RecipeCacheKey(Item stack, boolean hasMilk, boolean hasWater) {
    }
}

