/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.gas;

import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.starbuncle.gas.StarbyGasBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;

public class GasExtractGoal
extends GoToPosGoal<StarbyGasBehavior> {
    public GasExtractGoal(Starbuncle starbuncle, StarbyGasBehavior behavior) {
        super(starbuncle, (StarbyBehavior)behavior, () -> behavior.getGasStack().isEmpty());
    }

    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    public BlockPos getDestination() {
        return ((StarbyGasBehavior)this.behavior).getTankToExtract();
    }

    public boolean onDestinationReached() {
        IChemicalHandler gasHandlerExtract = ((StarbyGasBehavior)this.behavior).getHandlerFromCap(this.targetPos, (Direction)((StarbyGasBehavior)this.behavior).FROM_DIRECTION_MAP.get(this.targetPos.hashCode()));
        int tankIndexE = 0;
        if (gasHandlerExtract != null) {
            ChemicalStack toExtract = gasHandlerExtract.getChemicalInTank(tankIndexE);
            BlockPos pos = ((StarbyGasBehavior)this.behavior).getTankForStorage(toExtract.copyWithAmount((long)((StarbyGasBehavior)this.behavior).getRatio()));
            if (pos == null) {
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoRoom", "No Room for " + toExtract.getChemicalHolder().getRegisteredName() + " from " + this.targetPos.toString()));
                return true;
            }
            IChemicalHandler gasHandlerStore = ((StarbyGasBehavior)this.behavior).getHandlerFromCap(pos, (Direction)((StarbyGasBehavior)this.behavior).TO_DIRECTION_MAP.get(pos.hashCode()));
            if (gasHandlerStore != null) {
                long maxRoom = -1L;
                for (int s = 0; s < gasHandlerStore.getChemicalTanks() && !(gasHandlerStore.getChemicalInTank(s).isEmpty() ? (maxRoom = gasHandlerStore.getChemicalTankCapacity(s)) > 0L : gasHandlerStore.getChemicalInTank(s).is(toExtract.getChemical()) && (maxRoom = gasHandlerStore.getChemicalTankCapacity(s) - gasHandlerStore.getChemicalInTank(s).getAmount()) > 0L); ++s) {
                }
                if (maxRoom <= (long)((Integer)Configs.STARBALLOON_THRESHOLD.get()).intValue()) {
                    return true;
                }
                int takeAmount = (int)Math.min(toExtract.getAmount(), Math.min(maxRoom, (long)((StarbyGasBehavior)this.behavior).getRatio()));
                this.starbuncle.level().playSound(null, this.targetPos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.NEUTRAL, 0.2f, 1.3f);
                ChemicalStack extracted = toExtract.copyWithAmount((long)takeAmount);
                ((StarbyGasBehavior)this.behavior).setGasStack(gasHandlerExtract.extractChemical(extracted, Action.EXECUTE));
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("SetHeld", "Taking " + takeAmount + "x " + extracted.getChemicalHolder().getRegisteredName() + " from " + this.targetPos.toString()));
            } else {
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No gas handler at " + this.targetPos.toString()));
            }
        } else {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoHandler", "No gas handler at " + this.targetPos.toString()));
        }
        return true;
    }
}

