/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.block.fluids;

import alexthw.starbunclemania.common.block.fluids.AbstractTankTile;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class LiquidJarTile
extends AbstractTankTile
implements ITooltipProvider,
ITickable {
    public static final int capacity = 16000;

    public LiquidJarTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUID_JAR_TILE.get(), pos, state);
    }

    public float getFluidPercentage() {
        return (float)this.getFluidAmount() / 16000.0f;
    }

    public void setFluid(FluidStack fluidFromTag) {
        this.tank.setFluid(fluidFromTag);
    }

    public void tick() {
        PotionContents potion;
        PotionJarTile potionJar;
        BlockEntity be;
        if (this.level instanceof ServerLevel && this.level.getGameTime() % 20L == 0L && !this.tank.isEmpty() && this.tank.getFluid().has(DataComponents.POTION_CONTENTS) && this.tank.getFluidAmount() >= 250 && this.tank.getFluid().is(ModRegistry.POTION) && (be = this.level.getBlockEntity(this.getBlockPos().above())) instanceof PotionJarTile && (potionJar = (PotionJarTile)be).getAmount() < potionJar.getMaxFill() && potionJar.canAccept(potion = (PotionContents)this.tank.getFluid().get(DataComponents.POTION_CONTENTS), 100)) {
            potionJar.add(potion, 100);
            this.tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void getTooltip(List<Component> tooltip) {
        FluidStack fluid = this.getFluid();
        LiquidJarTile.displayFluidTooltip(tooltip, fluid);
    }

    public static void displayFluidTooltip(Consumer<Component> tooltip, FluidStack fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        tooltip.accept((Component)Component.translatable((String)"starbunclemania.tooltip.fluid_jar", (Object[])new Object[]{fluid.getAmount()}).append(fluid.getHoverName()));
    }

    public static void displayFluidTooltip(List<Component> tooltip, FluidStack fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"starbunclemania.tooltip.fluid_jar", (Object[])new Object[]{fluid.getAmount()}).append(fluid.getHoverName()));
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder components) {
        components.set(ModRegistry.FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)this.tank.getFluid()));
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput componentInput) {
        SimpleFluidContent tankData = (SimpleFluidContent)componentInput.get(ModRegistry.FLUID_CONTENT);
        if (tankData != null) {
            this.tank.setFluid(tankData.copy());
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Fluid");
    }
}

