/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.client.HeadCosmeticRenderer;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class PropellerRenderer
extends HeadCosmeticRenderer {
    @Override
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float period = 40.0f;
        float maxSpeed = 1500.0f;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        matrixStack.pushPose();
        matrixStack.scale(0.65f, -0.65f, -0.65f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(-netHeadYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(-headPitch));
        matrixStack.mulPose(Axis.YP.rotationDegrees(player.onGround() ? 0.0f : (float)(Math.sin(ageInTicks / period) * (double)maxSpeed)));
        matrixStack.translate(0.0, (player.isCrouching() ? 1.4 : 2.0) - (double)player.getEyeHeight(), 0.0);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.HEAD, light, OverlayTexture.NO_OVERLAY, matrixStack, renderTypeBuffer, player.level(), 0);
        matrixStack.popPose();
        Random rand = ParticleUtil.r;
        Vec3 particlePos = player.position();
        float offsetY = player.isCrouching() ? 0.4f : 1.0f;
        float roteAngle = (float)((double)rand.nextFloat() * Math.PI * 2.0);
        if (rand.nextInt(5) == 0) {
            for (int i = 0; i < 5; ++i) {
                player.level().addParticle(ParticleSparkleData.createData((ParticleColor)new ParticleColor(52, 255, 36), (float)0.1f, (int)60), particlePos.x() + Math.cos(roteAngle), particlePos.y() + 0.5 + (double)offsetY, particlePos.z() + Math.sin(roteAngle), 0.0, 0.0, 0.0);
            }
        }
    }
}

