/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania;

import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.ReloadDocumentationEvent;
import com.hollingsworth.arsnouveau.api.documentation.builder.DocEntryBuilder;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.entry.TextEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.setup.registry.Documentation;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class StarbDocs {
    @SubscribeEvent
    public static void addPages(ReloadDocumentationEvent.AddEntries event) {
        StarbDocs.init(event);
    }

    private static void init(ReloadDocumentationEvent.AddEntries event) {
        StarbDocs.addBasicItem((ItemLike)ModRegistry.FLUID_JAR.get(), DocumentationRegistry.SOURCE);
        DocEntry condenser = StarbDocs.addBasicItem((ItemLike)ModRegistry.SOURCE_CONDENSER.get(), DocumentationRegistry.SOURCE);
        StarbDocs.addBasicItem((ItemLike)ModRegistry.FLUID_SOURCELINK.get(), DocumentationRegistry.SOURCE).withRelation(condenser);
        DocEntry dirScroll = StarbDocs.addBasicItem((ItemLike)ModRegistry.DIRECTION_SCROLL.get(), DocumentationRegistry.CRAFTING);
        DocEntry prof = StarbDocs.addBasicItem((ItemLike)ModRegistry.PROFHAT.get(), DocumentationRegistry.CRAFTING);
        Documentation.addPage((DocEntryBuilder)new DocEntryBuilder(DocumentationRegistry.CRAFTING, "starbunclemania.page.item_transfer").withIcon((ItemLike)ModRegistry.PROFHAT.get()).withSortNum(100).withPage(TextEntry.create((Component)Component.translatable((String)("starbunclemania.page." + RegistryHelper.getRegistryName((Item)((Item)ModRegistry.PROFHAT.get()).asItem()).getPath())), (Component)((Item)ModRegistry.PROFHAT.get()).getDescription(), (ItemLike)((ItemLike)ModRegistry.PROFHAT.get()))).withPage(TextEntry.create((Component)Component.translatable((String)"starbunclemania.page.robin_mask"), (Component)((Item)ModRegistry.ROBINHAT.get()).getDescription(), (ItemLike)((ItemLike)ModRegistry.ROBINHAT.get()))).withCraftingPages((ItemLike)ModRegistry.PROFHAT.get(), (ItemLike)ModRegistry.ROBINHAT.get())).withRelations(new DocEntry[]{dirScroll});
        DocEntry fluid = Documentation.addPage((DocEntryBuilder)new DocEntryBuilder(DocumentationRegistry.CRAFTING, (ItemLike)ModRegistry.STARBUCKET.get()).withTextPage("starbunclemania.page.star_bucket").withCraftingPages((ItemLike)ModRegistry.STARBUCKET.get()).withTextPage("starbunclemania.page.fluid_scroll").withCraftingPages((ItemLike)ModRegistry.FLUID_SCROLL_ALLOW.get()).withCraftingPages((ItemLike)ModRegistry.FLUID_SCROLL_DENY.get())).withRelation(dirScroll);
        DocEntry balloon = StarbDocs.addBasicItem((ItemLike)ModRegistry.STARBALLON.get(), DocumentationRegistry.CRAFTING);
        DocEntry thrash = StarbDocs.addBasicItem((ItemLike)ModRegistry.STARTRASH.get(), DocumentationRegistry.CRAFTING);
        DocEntry battery = StarbDocs.addBasicItem((ItemLike)ModRegistry.STARBATTERY.get(), DocumentationRegistry.CRAFTING);
        DocEntry saddle = StarbDocs.addBasicItem((ItemLike)ModRegistry.STARSADDLE.get(), DocumentationRegistry.CRAFTING);
        Documentation.addPage((DocEntryBuilder)new DocEntryBuilder("starbunclemania", DocumentationRegistry.CRAFTING, "starbunclemania.page.wixie_jobs").withIcon((ItemLike)ItemsRegistry.WIXIE_CHARM).withTextPage("starbunclemania.page.wixie_cook").withTextPage("starbunclemania.page.wixie_cut").withTextPage("starbunclemania.page.wixie_mixer"));
        Documentation.addPage((DocEntryBuilder)new DocEntryBuilder(DocumentationRegistry.ITEMS, (ItemLike)ModRegistry.STARBY_EARS.get()).withName("starbunclemania.player_cosmetic").withTextPage("starbunclemania.page.player_cosmetic").withCraftingPages((ItemLike)ModRegistry.STARBY_EARS.get()).withCraftingPages((ItemLike)ModRegistry.ALAK_HAT.get()).withCraftingPages((ItemLike)ModRegistry.SEA_BUNNY.get()).withCraftingPages((ItemLike)ModRegistry.DRYGMY_HORNS.get()).withCraftingPages((ItemLike)ModRegistry.WHIRLI_PROP.get()));
        Documentation.addPage((DocEntryBuilder)new DocEntryBuilder(DocumentationRegistry.FAMILIARS, ((Item)ModRegistry.STARHAT.get()).getDescriptionId()).withIcon((ItemLike)ModRegistry.STARHAT.get()).withSortNum(100).withPage(TextEntry.create((Component)Component.translatable((String)("starbunclemania.page." + RegistryHelper.getRegistryName((Item)((Item)ModRegistry.STARHAT.get()).asItem()).getPath())), (Component)((Item)ModRegistry.STARHAT.get()).getDescription(), (ItemLike)((ItemLike)ModRegistry.STARHAT.get()))).withCraftingPages((ItemLike)ModRegistry.STARHAT.get()).withCraftingPages((ItemLike)ModRegistry.CHEF_HAT.get())).withRelations(new DocEntry[]{balloon, thrash, battery, fluid, prof});
    }

    public static DocEntry addBasicItem(ItemLike item, DocCategory category) {
        ItemStack stack = new ItemStack(item);
        return Documentation.addPage((DocEntryBuilder)new DocEntryBuilder(category, stack.getDescriptionId()).withIcon(item).withSortNum(100).withPage(TextEntry.create((Component)Component.translatable((String)("starbunclemania.page." + RegistryHelper.getRegistryName((Item)item.asItem()).getPath())), (Component)stack.getItem().getDescription(), (ItemStack)stack)).withCraftingPages(item));
    }

    @SubscribeEvent
    public static void editPages(ReloadDocumentationEvent.Post event) {
        StarbDocs.postInit(event);
    }

    private static void postInit(ReloadDocumentationEvent.Post event) {
    }
}

