/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.automaticdoors_common_forge.util;

import com.natamus.automaticdoors_common_forge.config.ConfigHandler;
import com.natamus.automaticdoors_common_forge.events.DoorEvent;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;

public class Util {
    private static final List<BlockPos> runnables = new ArrayList<BlockPos>();

    public static Boolean isDoor(Block block) {
        if (block instanceof DoorBlock) {
            if (!ConfigHandler.shouldOpenIronDoors) {
                String name = block.toString().toLowerCase();
                return !name.contains("iron");
            }
            return true;
        }
        return false;
    }

    public static void delayDoorClose(Level level, BlockPos pos) {
        if (pos == null) {
            return;
        }
        if (runnables.contains(pos)) {
            return;
        }
        runnables.add(pos);
        if (!level.isClientSide) {
            TaskFunctions.enqueueCollectiveTask((MinecraftServer)level.getServer(), () -> {
                if (!DoorEvent.toclosedoors.get(level).contains(pos) && !DoorEvent.newclosedoors.get(level).contains(pos)) {
                    DoorEvent.newclosedoors.get(level).add(pos);
                }
                runnables.remove(pos);
            }, (int)(ConfigHandler.doorOpenTime / 1000 * 20));
        }
    }
}

