/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ContainerInput;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardCombiningRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardSlicingRecipe;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CuttingBoardHelperOverlay
implements IHudOverlay {
    private static final int COLUMNS = 7;
    private static final int TITLE_HEIGHT = 13;

    @Override
    public void draw(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (!((Boolean)Config.CLIENT.showCuttingBoardHelper.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.hitResult == null || mc.player == null) {
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        BlockEntity entity = mc.level.getBlockEntity(result.getBlockPos());
        if (!(entity instanceof CuttingBoardBlockEntity)) {
            return;
        }
        CuttingBoardBlockEntity cuttingBoard = (CuttingBoardBlockEntity)entity;
        int placeIndex = cuttingBoard.getPlaceIndex();
        SimpleContainer container = new SimpleContainer(placeIndex);
        IntStream.range(0, placeIndex).forEach(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$0((Container)container, cuttingBoard, arg_0));
        List recipes = mc.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get());
        Stream<Item> combinable = recipes.stream().filter(arg_0 -> CuttingBoardHelperOverlay.lambda$draw$1((Container)container, mc, placeIndex, arg_0)).flatMap(holder -> Stream.of(((Ingredient)((CuttingBoardCombiningRecipe)holder.value()).getIngredients().get(placeIndex)).getItems())).map(ItemStack::getItem);
        Stream<Item> sliceable = mc.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get()).stream().flatMap(holder -> Stream.of(((Ingredient)((CuttingBoardSlicingRecipe)holder.value()).getIngredients().get(0)).getItems())).map(ItemStack::getItem);
        Stream<Item> items = placeIndex == 0 ? Stream.concat(combinable, sliceable) : combinable;
        List<Item> placeable = items.distinct().sorted(Comparator.comparing(Item::getId)).toList();
        boolean drawPlaceableElement = !placeable.isEmpty();
        boolean drawSliceableElement = this.canSlice(cuttingBoard);
        int areaWidth = 134;
        int areaHeight = this.getAreaHeight(placeable, drawPlaceableElement, drawSliceableElement);
        int areaStart = 5;
        int areaTop = (graphics.guiHeight() - areaHeight) / 2;
        if (drawPlaceableElement) {
            int elementHeight = this.getPlaceableHeight(placeable);
            ScreenHelper.fillRounded(graphics, areaStart, areaTop, areaWidth, elementHeight, -1728053248);
            ScreenHelper.fillRounded(graphics, areaStart, areaTop, areaWidth, 13, -1728053248);
            graphics.drawCenteredString(Minecraft.getInstance().font, Components.GUI_PLACEABLE, areaStart + areaWidth / 2, areaTop + 2, -1);
            for (int i = 0; i < placeable.size(); ++i) {
                int x = areaStart + i % 7 * 18 + 1 + 4;
                int y = areaTop + i / 7 * 18 + 1 + 4 + 13;
                graphics.renderFakeItem(new ItemStack((ItemLike)placeable.get(i)), x, y);
            }
        }
        if (drawSliceableElement) {
            Component sliceableLabel = Components.GUI_SLICEABLE;
            int elementHeight = 18;
            int contentWidth = 18 + Minecraft.getInstance().font.width((FormattedText)sliceableLabel);
            int contentTop = areaTop + areaHeight - elementHeight;
            int labelStart = areaStart + (areaWidth - contentWidth) / 2;
            ScreenHelper.fillRounded(graphics, areaStart, contentTop, areaWidth, elementHeight, -1724404169);
            graphics.renderFakeItem(new ItemStack((ItemLike)ModItems.KNIFE.get()), labelStart, contentTop + 1);
            graphics.drawString(Minecraft.getInstance().font, sliceableLabel, labelStart + 18, contentTop + 5, -1);
        }
    }

    private int getAreaHeight(List<Item> placeable, boolean combining, boolean slicing) {
        int height = 0;
        if (combining) {
            height += this.getPlaceableHeight(placeable);
        }
        if (slicing) {
            height += 18;
        }
        if (combining && slicing) {
            height += 5;
        }
        return height;
    }

    private int getPlaceableHeight(List<Item> placeable) {
        return (placeable.size() / 7 + 1) * 18 + 1 + 8 + 13;
    }

    private boolean canSlice(CuttingBoardBlockEntity entity) {
        ItemStack placedItem = entity.getItem(0);
        if (entity.getHeadIndex() == 0 && !placedItem.isEmpty()) {
            Level level = Objects.requireNonNull(entity.getLevel());
            return level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get(), (RecipeInput)new SingleRecipeInput(placedItem), level).isPresent();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$draw$1(Container container, Minecraft mc, int placeIndex, RecipeHolder holder) {
        return ((CuttingBoardCombiningRecipe)holder.value()).matches(new ContainerInput(container), (Level)mc.level) && placeIndex < ((CuttingBoardCombiningRecipe)holder.value()).getIngredients().size();
    }

    private static /* synthetic */ void lambda$draw$0(Container container, CuttingBoardBlockEntity cuttingBoard, int index) {
        container.setItem(index, cuttingBoard.getItem(index));
    }
}

