/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.FridgeBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.RowedStorageBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FridgeBlockEntity
extends RowedStorageBlockEntity {
    public static final int ROWS = 3;

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FRIDGE.get(), pos, state, 3);
    }

    public FridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int rows) {
        super(type, pos, state, rows);
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "fridge", new Object[0]);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)FridgeBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, center.x, center.y, center.z, (SoundEvent)ModSounds.BLOCK_FRIDGE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition).relative(((Direction)state.getValue((Property)FridgeBlock.DIRECTION)).getOpposite(), 0.5);
        level.playSound(null, center.x, center.y, center.z, (SoundEvent)ModSounds.BLOCK_FRIDGE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.random.nextFloat());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.getLevel();
        if (level != null) {
            level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)FridgeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

