/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureBlock;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends FurnitureBlock
implements BlockTagSupplier {
    private static final MapCodec<TableBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.type), (App)TableBlock.propertiesCodec()).apply((Applicative)builder, TableBlock::new));
    private final WoodType type;

    public TableBlock(WoodType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public WoodType getWoodType() {
        return this.type;
    }

    protected MapCodec<TableBlock> codec() {
        return CODEC;
    }

    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape topNorthEdgeShape = Block.box((double)0.0, (double)14.0, (double)-1.0, (double)16.0, (double)16.0, (double)0.0);
        VoxelShape topEastEdgeShape = Block.box((double)16.0, (double)14.0, (double)0.0, (double)17.0, (double)16.0, (double)16.0);
        VoxelShape topSouthEdgeShape = Block.box((double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0, (double)17.0);
        VoxelShape topWestEdgeShape = Block.box((double)-1.0, (double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0);
        VoxelShape northWestTopCornerShape = Block.box((double)-1.0, (double)14.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0);
        VoxelShape northEastTopCornerShape = Block.box((double)16.0, (double)14.0, (double)-1.0, (double)17.0, (double)16.0, (double)0.0);
        VoxelShape southWestTopCornerShape = Block.box((double)-1.0, (double)14.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0);
        VoxelShape southEastTopCornerShape = Block.box((double)16.0, (double)14.0, (double)16.0, (double)17.0, (double)16.0, (double)17.0);
        VoxelShape northWestLegShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
        VoxelShape northEastLegShape = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape southWestLegShape = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
        VoxelShape southEastLegShape = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean east = (Boolean)state.getValue((Property)EAST);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            boolean west = (Boolean)state.getValue((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            if (!north) {
                shapes.add(topNorthEdgeShape);
                if (!east) {
                    shapes.add(northEastTopCornerShape);
                    shapes.add(northEastLegShape);
                }
                if (!west) {
                    shapes.add(northWestTopCornerShape);
                    shapes.add(northWestLegShape);
                }
            }
            if (!east) {
                shapes.add(topEastEdgeShape);
            }
            if (!south) {
                shapes.add(topSouthEdgeShape);
                if (!east) {
                    shapes.add(southEastTopCornerShape);
                    shapes.add(southEastLegShape);
                }
                if (!west) {
                    shapes.add(southWestTopCornerShape);
                    shapes.add(southWestLegShape);
                }
            }
            if (!west) {
                shapes.add(topWestEdgeShape);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapes.get(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = level.getBlockState(pos.north()).getBlock() instanceof TableBlock;
        boolean east = level.getBlockState(pos.east()).getBlock() instanceof TableBlock;
        boolean south = level.getBlockState(pos.south()).getBlock() instanceof TableBlock;
        boolean west = level.getBlockState(pos.west()).getBlock() instanceof TableBlock;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH});
        builder.add(new Property[]{EAST});
        builder.add(new Property[]{SOUTH});
        builder.add(new Property[]{WEST});
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_AXE, ModTags.Blocks.TUCKABLE);
    }
}

