/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.util.rituals.ItemMultiSet;
import net.alshanex.alshanex_familiars.util.rituals.RitualHelper;
import net.alshanex.alshanex_familiars.util.rituals.RitualRecipe;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import org.joml.Vector3f;

public class RitualRecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public RitualRecipeManager() {
        super(GSON, "ritual_recipes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList, ResourceManager resourceManager, ProfilerFiller profiler) {
        AlshanexFamiliarsMod.LOGGER.info("Loading ritual recipes...");
        RitualHelper.initializeRecipes();
        resourceList.forEach((location, jsonElement) -> {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"ritual recipe");
                this.loadRitualRecipe((ResourceLocation)location, json);
            }
            catch (Exception e) {
                AlshanexFamiliarsMod.LOGGER.error("Error loading ritual recipe {}: {}", location, (Object)e.getMessage());
                e.printStackTrace();
            }
        });
        RitualHelper.debugPrintAllRecipes();
        AlshanexFamiliarsMod.LOGGER.info("Loaded {} ritual recipes", (Object)RitualHelper.getRitualRecipes().size());
    }

    private void loadRitualRecipe(ResourceLocation location, JsonObject json) {
        AlshanexFamiliarsMod.LOGGER.debug("Loading ritual recipe from {}", (Object)location);
        String centralItemId = GsonHelper.getAsString((JsonObject)json, (String)"central_item");
        String[] centralItemParts = centralItemId.split(":", 2);
        String centralItemNamespace = centralItemParts.length > 1 ? centralItemParts[0] : "minecraft";
        String centralItemPath = centralItemParts.length > 1 ? centralItemParts[1] : centralItemParts[0];
        ResourceLocation centralItemRL = new ResourceLocation(centralItemNamespace, centralItemPath);
        Item centralItem = (Item)BuiltInRegistries.ITEM.get(centralItemRL);
        if (centralItem == null) {
            AlshanexFamiliarsMod.LOGGER.error("Unknown central item: {}", (Object)centralItemId);
            return;
        }
        JsonArray inputItemsJson = GsonHelper.getAsJsonArray((JsonObject)json, (String)"input_items");
        ItemMultiSet inputItems = new ItemMultiSet();
        AlshanexFamiliarsMod.LOGGER.debug("Recipe {} has {} input items", (Object)location, (Object)inputItemsJson.size());
        for (int i = 0; i < Math.min(inputItemsJson.size(), 4); ++i) {
            String path;
            JsonElement element = inputItemsJson.get(i);
            String itemId = element.getAsString();
            String[] parts = itemId.split(":", 2);
            String namespace = parts.length > 1 ? parts[0] : "minecraft";
            ResourceLocation itemRL = new ResourceLocation(namespace, path = parts.length > 1 ? parts[1] : parts[0]);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemRL);
            if (item == null) {
                AlshanexFamiliarsMod.LOGGER.error("Unknown input item: {}", (Object)itemId);
                return;
            }
            inputItems.add(item);
            AlshanexFamiliarsMod.LOGGER.debug("Added input item {} to recipe {}", (Object)itemId, (Object)location);
        }
        String resultItemId = GsonHelper.getAsString((JsonObject)json, (String)"result");
        AlshanexFamiliarsMod.LOGGER.debug("Recipe {} has result {}", (Object)location, (Object)resultItemId);
        String[] resultParts = resultItemId.split(":", 2);
        String resultNamespace = resultParts.length > 1 ? resultParts[0] : "minecraft";
        String resultPath = resultParts.length > 1 ? resultParts[1] : resultParts[0];
        ResourceLocation resultItemRL = new ResourceLocation(resultNamespace, resultPath);
        Item resultItem = (Item)BuiltInRegistries.ITEM.get(resultItemRL);
        if (resultItem == null) {
            AlshanexFamiliarsMod.LOGGER.error("Unknown or missing result item: {}", (Object)resultItemId);
            AlshanexFamiliarsMod.LOGGER.error("ResourceLocation was: {}", (Object)resultItemRL);
            return;
        }
        AlshanexFamiliarsMod.LOGGER.debug("Result item {} resolved to {}", (Object)resultItemId, (Object)resultItem);
        SimpleParticleType particles = ParticleTypes.ENCHANT;
        if (json.has("particle_type")) {
            String particlePath;
            String particleTypeId = GsonHelper.getAsString((JsonObject)json, (String)"particle_type");
            String[] particleParts = particleTypeId.split(":", 2);
            String particleNamespace = particleParts.length > 1 ? particleParts[0] : "minecraft";
            ResourceLocation particleRL = new ResourceLocation(particleNamespace, particlePath = particleParts.length > 1 ? particleParts[1] : particleParts[0]);
            ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(particleRL);
            if (particleType instanceof SimpleParticleType) {
                SimpleParticleType simpleParticleType;
                particles = simpleParticleType = (SimpleParticleType)particleType;
            } else {
                AlshanexFamiliarsMod.LOGGER.warn("Particle type {} is not a SimpleParticleType, using default", (Object)particleTypeId);
            }
        }
        Vector3f color = new Vector3f(1.0f, 1.0f, 1.0f);
        if (json.has("color")) {
            JsonObject colorJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)"color");
            float r = GsonHelper.getAsFloat((JsonObject)colorJson, (String)"r", (float)1.0f);
            float g = GsonHelper.getAsFloat((JsonObject)colorJson, (String)"g", (float)1.0f);
            float b = GsonHelper.getAsFloat((JsonObject)colorJson, (String)"b", (float)1.0f);
            color = new Vector3f(r, g, b);
        }
        RitualRecipe recipe = new RitualRecipe(centralItem, inputItems);
        RitualHelper.addRitualRecipe(recipe, resultItem, (ParticleOptions)particles, color);
        AlshanexFamiliarsMod.LOGGER.debug("Registered ritual recipe {} with result {}", (Object)location, (Object)resultItemId);
    }
}

