/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.block.entity.FamiliarStatueEntity;
import net.alshanex.alshanex_familiars.util.rituals.ItemMultiSet;
import net.alshanex.alshanex_familiars.util.rituals.RitualRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class RitualHelper {
    private static Map<RitualRecipe, Item> ritualRecipes;
    private static Map<Item, ParticleOptions> resultToParticle;
    private static Map<Item, Vector3f> resultToColor;

    public static boolean isValidRecipe(Level level, BlockPos centralPos, ItemStack stack) {
        Map<RitualRecipe, Item> recipes = RitualHelper.getRitualRecipes();
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centralPos, level);
        if (surroundingPedestals.size() < 4) {
            return false;
        }
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        RitualRecipe recipe = new RitualRecipe(stack.getItem(), pedestalItems);
        return recipes.get(recipe) != null;
    }

    public static List<BlockEntity> getSurroundingPedestals(BlockPos origin, Level level) {
        BlockPos[] offsets = new BlockPos[]{origin.north(2), origin.south(2), origin.east(2), origin.west(2)};
        ArrayList<BlockEntity> pedestals = new ArrayList<BlockEntity>();
        for (BlockPos pos : offsets) {
            FamiliarStatueEntity pedestal;
            BlockEntity entity = level.getBlockEntity(pos);
            if (!(entity instanceof FamiliarStatueEntity) || !(entity instanceof FamiliarStatueEntity) || (pedestal = (FamiliarStatueEntity)entity).getHeldItem() == ItemStack.EMPTY) continue;
            pedestals.add(pedestal);
        }
        return pedestals;
    }

    public static void spawnParticlesAtPedestals(ParticleOptions particles, BlockPos origin, Level pLevel) {
        if (!pLevel.isClientSide()) {
            BlockPos[] offsets = new BlockPos[]{origin.north(2), origin.south(2), origin.east(2), origin.west(2)};
            MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)origin.getX(), (double)(origin.getY() + 2), (double)origin.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            for (BlockPos pos : offsets) {
                MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)pos.getX(), (double)(pos.getY() + 2), (double)pos.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            }
        }
    }

    public static ItemMultiSet getItemsFromPedestals(List<BlockEntity> surroundingPedestals) {
        ItemMultiSet pedestalItems = new ItemMultiSet();
        for (BlockEntity pedestal : surroundingPedestals) {
            if (!(pedestal instanceof FamiliarStatueEntity)) continue;
            FamiliarStatueEntity statue = (FamiliarStatueEntity)pedestal;
            pedestalItems.add(statue.getHeldItem().getItem());
        }
        return pedestalItems;
    }

    public static void clearItemsFromPedestals(Level level, BlockPos pos) {
        for (BlockEntity pedestal : RitualHelper.getSurroundingPedestals(pos, level)) {
            if (!(pedestal instanceof FamiliarStatueEntity)) continue;
            FamiliarStatueEntity statue = (FamiliarStatueEntity)pedestal;
            BlockState prevState = statue.getBlockState();
            statue.setHeldItem(ItemStack.EMPTY);
            BlockState nextState = statue.getBlockState();
            level.sendBlockUpdated(statue.getBlockPos(), prevState, nextState, 2);
        }
    }

    public static Item getResultForRecipe(Level level, BlockPos centerPos, ItemStack stack) {
        Map<RitualRecipe, Item> recipes = RitualHelper.getRitualRecipes();
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centerPos, level);
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        RitualRecipe recipe = new RitualRecipe(stack.getItem(), pedestalItems);
        Item result = recipes.get(recipe);
        if (result == null) {
            AlshanexFamiliarsMod.LOGGER.warn("No result found for ritual with central item {} and inputs {}", (Object)stack.getItem(), (Object)pedestalItems);
        }
        return result;
    }

    public static void addRitualRecipe(RitualRecipe recipe, Item result, ParticleOptions particles, Vector3f color) {
        if (ritualRecipes == null) {
            RitualHelper.initializeRecipes();
        }
        AlshanexFamiliarsMod.LOGGER.debug("Adding ritual recipe: Central={}, Inputs={}, Result={}", new Object[]{recipe.getCentralItem(), recipe.getInputItems(), result});
        if (result == null) {
            AlshanexFamiliarsMod.LOGGER.error("Attempted to register a ritual recipe with null result item!");
            return;
        }
        boolean alreadyExists = false;
        for (Map.Entry<RitualRecipe, Item> entry : ritualRecipes.entrySet()) {
            if (!entry.getKey().equals(recipe)) continue;
            alreadyExists = true;
            AlshanexFamiliarsMod.LOGGER.warn("Duplicate recipe found! Existing result: {}, New result: {}", (Object)entry.getValue(), (Object)result);
            break;
        }
        if (!alreadyExists) {
            ritualRecipes.put(recipe, result);
            resultToParticle.put(result, particles);
            resultToColor.put(result, color);
            AlshanexFamiliarsMod.LOGGER.debug("Successfully registered ritual recipe with result {}", (Object)result);
        } else {
            AlshanexFamiliarsMod.LOGGER.warn("Skipped registering duplicate ritual recipe for {}", (Object)result);
        }
    }

    public static void initializeRecipes() {
        AlshanexFamiliarsMod.LOGGER.info("Initializing ritual recipes");
        if (ritualRecipes == null) {
            ritualRecipes = new HashMap<RitualRecipe, Item>();
        } else {
            ritualRecipes.clear();
        }
        if (resultToParticle == null) {
            resultToParticle = new HashMap<Item, ParticleOptions>();
        } else {
            resultToParticle.clear();
        }
        if (resultToColor == null) {
            resultToColor = new HashMap<Item, Vector3f>();
        } else {
            resultToColor.clear();
        }
    }

    public static Map<RitualRecipe, Item> getRitualRecipes() {
        if (ritualRecipes == null) {
            RitualHelper.initializeRecipes();
        }
        return ritualRecipes;
    }

    public static ParticleOptions getParticleForItem(Item item) {
        ParticleOptions particles = resultToParticle.get(item);
        return particles != null ? particles : ParticleTypes.ENCHANT;
    }

    public static Vector3f getColorForParticles(ParticleOptions particles) {
        for (Map.Entry<Item, ParticleOptions> entry : resultToParticle.entrySet()) {
            Item item;
            Vector3f color;
            if (!entry.getValue().equals((Object)particles) || (color = resultToColor.get(item = entry.getKey())) == null) continue;
            return color;
        }
        return ((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor();
    }

    public static void debugPrintAllRecipes() {
        AlshanexFamiliarsMod.LOGGER.info("=== DEBUG: All Registered Ritual Recipes ===");
        if (ritualRecipes == null || ritualRecipes.isEmpty()) {
            AlshanexFamiliarsMod.LOGGER.info("No recipes registered!");
            return;
        }
        int count = 0;
        for (Map.Entry<RitualRecipe, Item> entry : ritualRecipes.entrySet()) {
            RitualRecipe recipe = entry.getKey();
            Item result = entry.getValue();
            AlshanexFamiliarsMod.LOGGER.info("Recipe #{}: Central={}, Inputs={}, Result={}", new Object[]{count++, recipe.getCentralItem(), recipe.getInputItems(), result});
        }
        AlshanexFamiliarsMod.LOGGER.info("=== END DEBUG ===");
    }
}

