/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util;

import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummoningUtils {
    public static void handlePetSummoning(ServerPlayer player) {
        ItemStack trinket;
        if (CurioUtils.isWearingFamiliarTrinket((LivingEntity)player) && (trinket = CurioUtils.getFamiliarTrinket((LivingEntity)player)) != null && trinket.has(DataComponentRegistry.FAMILIAR_TRINKET)) {
            CompoundTag nbt = (CompoundTag)trinket.get(DataComponentRegistry.FAMILIAR_TRINKET);
            boolean isSummoned = nbt.getBoolean("isSummoned");
            if (isSummoned) {
                AbstractSpellCastingPet pet;
                ServerLevel world2;
                Entity entity;
                UUID petUUID = nbt.getUUID("petUUID");
                Level level = player.level();
                if (level instanceof ServerLevel && (entity = (world2 = (ServerLevel)level).getEntity(petUUID)) != null && entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().is((Entity)player)) {
                    nbt.putFloat("currentHealth", pet.getHealth());
                    nbt.putBoolean("isSummoned", false);
                    pet.setTarget(null);
                    pet.cancelCast();
                    pet.saveWithoutId(nbt);
                    trinket.set(DataComponentRegistry.FAMILIAR_TRINKET, (Object)nbt);
                    pet.remove(Entity.RemovalReason.DISCARDED);
                }
            } else {
                AbstractSpellCastingPet pet;
                ServerLevel world;
                Entity entity;
                Level world2 = player.level();
                if (world2 instanceof ServerLevel && (entity = SummoningUtils.getEntityFromStack(trinket, (Level)(world = (ServerLevel)world2), true)) instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().is((Entity)player)) {
                    float currentHealth = nbt.getFloat("currentHealth");
                    pet.setHealth(currentHealth);
                    float yrot = 6.281f + player.getYRot() * ((float)Math.PI / 180);
                    Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)player.getEyePosition().add(new Vec3((double)(3.0f * Mth.cos((float)yrot)), 0.0, (double)(3.0f * Mth.sin((float)yrot)))), (int)10);
                    pet.setPos(spawn.x, spawn.y, spawn.z);
                    pet.setYRot(player.getYRot());
                    pet.setOldPosAndRot();
                    world.addFreshEntity(entity);
                    nbt.putBoolean("isSummoned", true);
                    pet.saveWithoutId(nbt);
                    trinket.set(DataComponentRegistry.FAMILIAR_TRINKET, (Object)nbt);
                }
            }
        }
    }

    @Nullable
    public static Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        CompoundTag nbt;
        EntityType type;
        if (stack.has(DataComponentRegistry.FAMILIAR_TRINKET) && (type = (EntityType)EntityType.byString((String)(nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET)).getString("entity")).orElse(null)) != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(nbt);
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        return null;
    }
}

