/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.alshanex.alshanex_familiars.entity.ShadowEntity;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ShadowSummonSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("alshanex_familiars", "summon_shadows");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(6).setCooldownSeconds(150.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.summon_count", (Object[])new Object[]{spellLevel}));
    }

    public ShadowSummonSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 30;
        this.baseManaCost = 50;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_START.value());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_FINISH.value());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 400;
        float radius = 1.5f + 0.185f * (float)spellLevel;
        for (int i = 0; i < spellLevel; ++i) {
            ShadowEntity shadowEntity = new ShadowEntity(world, entity);
            shadowEntity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.RAISE_DEAD_TIMER, summonTime, 0, false, false, false));
            float yrot = 6.281f / (float)spellLevel * (float)i + entity.getYRot() * ((float)Math.PI / 180);
            Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)entity.getEyePosition().add(new Vec3((double)(radius * Mth.cos((float)yrot)), 0.0, (double)(radius * Mth.sin((float)yrot)))), (int)10);
            shadowEntity.setPos(spawn.x, spawn.y, spawn.z);
            shadowEntity.setYRot(entity.getYRot());
            shadowEntity.setOldPosAndRot();
            world.addFreshEntity((Entity)shadowEntity);
        }
        int effectAmplifier = spellLevel - 1;
        if (entity.hasEffect((Holder)MobEffectRegistry.RAISE_DEAD_TIMER)) {
            effectAmplifier += entity.getEffect((Holder)MobEffectRegistry.RAISE_DEAD_TIMER).getAmplifier() + 1;
        }
        entity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.RAISE_DEAD_TIMER, summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }
}

