/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.registry;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataComponentRegistry {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"alshanex_familiars");
    public static final Supplier<DataComponentType<CompoundTag>> FAMILIAR_TOME = DataComponentRegistry.register("familiar_tome", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> PET_SOUL = DataComponentRegistry.register("pet_soul", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> FAMILIAR_TRINKET = DataComponentRegistry.register("familiar_trinket", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<List<CompoundTag>>> PANDORA_BOX = DataComponentRegistry.register("pandora_box", ArrayList::new, op -> op.persistent(Codec.list((Codec)CompoundTag.CODEC)));
    public static final Supplier<DataComponentType<CompoundTag>> PET_BED_COLOR = DataComponentRegistry.register("pet_bed_color", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENT_TYPES.register(eventBus);
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

