/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class EvasionCurio
extends SimpleDescriptiveCurio {
    public EvasionCurio(Item.Properties properties) {
        super(properties.rarity(Rarity.EPIC), Curios.RING_SLOT);
    }

    private void handleEvasion(SlotContext slotContext) {
        LivingEntity entity = slotContext.entity();
        if (entity != null && !slotContext.entity().level.isClientSide && CurioUtils.isWearingCurio(slotContext.entity(), (Item)ItemRegistry.EVASION_CURIO.get())) {
            this.addEvasion(slotContext.entity().level, slotContext.entity());
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        if (slotContext.entity().tickCount % 100 == 0) {
            this.handleEvasion(slotContext);
        }
    }

    private void addEvasion(Level level, LivingEntity player) {
        List entities = level.getEntities((Entity)player, player.getBoundingBox().inflate(20.0), entity -> {
            AbstractSpellCastingPet pet;
            return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)entity)).getSummoner() != null && pet.getSummoner().is((Entity)player);
        });
        for (Entity entity2 : entities) {
            AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity2;
            if (!(pet.getHealth() <= pet.getMaxHealth() / 4.0f)) continue;
            pet.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.EVASION, 100, 2, false, false, true));
        }
    }
}

