/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.List;
import java.util.UUID;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFamiliarTrinket
extends CurioBaseItem {
    private static final Component DESCRIPTION = Component.translatable((String)"item.alshanex_familiars.familiar_trinket.desc").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});

    public AbstractFamiliarTrinket() {
        super(ItemPropertiesHelper.equipment().stacksTo(1).rarity(Rarity.EPIC));
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.isValidPet(target)) {
            return InteractionResult.FAIL;
        }
        if (!this.bind(stack, target, playerIn)) {
            return InteractionResult.FAIL;
        }
        playerIn.swing(hand);
        playerIn.setItemInHand(hand, stack);
        return InteractionResult.SUCCESS;
    }

    protected boolean isValidPet(LivingEntity target) {
        return target instanceof AbstractSpellCastingPet;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        lines.add(DESCRIPTION);
        if (itemStack.has(DataComponentRegistry.FAMILIAR_TRINKET)) {
            CompoundTag nbt = (CompoundTag)itemStack.get(DataComponentRegistry.FAMILIAR_TRINKET);
            float currentHealth = nbt.getFloat("currentHealth");
            int enragedStacks = nbt.getInt("enragedStacks");
            boolean canBlock = nbt.getBoolean("isBlocking");
            String chanceToBlock = canBlock ? "10% chance to block an incoming attack" : "0% chance to block an incoming attack";
            int armorStacks = nbt.getInt("armorStacks");
            lines.add((Component)Component.literal((String)("Current health: " + currentHealth)).withStyle(ChatFormatting.GREEN));
            lines.add((Component)Component.literal((String)("Additional armor points: " + armorStacks)).withStyle(ChatFormatting.AQUA));
            lines.add((Component)Component.literal((String)("Enraged stacks: " + enragedStacks)).withStyle(ChatFormatting.LIGHT_PURPLE));
            lines.add((Component)Component.literal((String)chanceToBlock).withStyle(ChatFormatting.GOLD));
        }
    }

    public boolean bind(ItemStack stack, LivingEntity target, Player player) {
        AbstractSpellCastingPet pet;
        if (target.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (!(target instanceof AbstractSpellCastingPet) || (pet = (AbstractSpellCastingPet)target).getSummoner() == null || !pet.getSummoner().is((Entity)player)) {
            return false;
        }
        if (stack.has(DataComponentRegistry.FAMILIAR_TRINKET)) {
            CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET);
            boolean isSummoned = nbt.getBoolean("isSummoned");
            if (isSummoned) {
                UUID petUUID = nbt.getUUID("petUUID");
                stack.remove(DataComponentRegistry.FAMILIAR_TRINKET);
                if (!target.getUUID().equals(petUUID)) {
                    CompoundTag nbtSwap = new CompoundTag();
                    nbtSwap.putUUID("petUUID", target.getUUID());
                    if (target.hasCustomName()) {
                        nbtSwap.putString("name", target.getCustomName().getString());
                    }
                    nbtSwap.putFloat("currentHealth", target.getHealth());
                    nbtSwap.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
                    nbtSwap.putBoolean("isSummoned", true);
                    target.saveWithoutId(nbtSwap);
                    stack.set(DataComponentRegistry.FAMILIAR_TRINKET, (Object)nbtSwap);
                }
                return true;
            }
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("petUUID", target.getUUID());
        if (target.hasCustomName()) {
            nbt.putString("name", target.getCustomName().getString());
        }
        nbt.putFloat("currentHealth", target.getHealth());
        nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
        nbt.putBoolean("isSummoned", true);
        target.saveWithoutId(nbt);
        stack.set(DataComponentRegistry.FAMILIAR_TRINKET, (Object)nbt);
        return true;
    }

    public String getID(ItemStack stack) {
        CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET);
        if (nbt.contains("name")) {
            return nbt.getString("name");
        }
        return nbt.getString("entity");
    }

    public Component getName(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.translatable((String)super.getDescriptionId(stack));
        }
        return Component.translatable((String)super.getDescriptionId(stack)).append(" (" + this.getID(stack) + ")");
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.isEmpty() && stack.has(DataComponentRegistry.FAMILIAR_TRINKET);
    }
}

