/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PandoraBox
extends Item {
    public PandoraBox(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.EPIC));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (stack.has(DataComponentRegistry.PANDORA_BOX)) {
            if (!this.release(player, level, stack)) {
                return InteractionResultHolder.fail((Object)stack);
            }
        } else {
            List<LivingEntity> pets = level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(15.0), entity -> {
                AbstractSpellCastingPet pet;
                return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)entity)).getSummoner() != null && pet.getSummoner().is((Entity)player) && !entity.getCommandSenderWorld().isClientSide;
            }).stream().toList();
            if (pets.isEmpty()) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!this.capture(stack, pets)) {
                return InteractionResultHolder.fail((Object)stack);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean capture(ItemStack stack, List<LivingEntity> targets) {
        ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
        for (int i = 0; i < Math.min(10, targets.size()); ++i) {
            CompoundTag nbt = new CompoundTag();
            LivingEntity target = targets.get(i);
            nbt.putFloat("currentHealthPet", target.getHealth());
            nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
            target.saveWithoutId(nbt);
            tags.add(nbt);
            target.remove(Entity.RemovalReason.DISCARDED);
        }
        stack.set(DataComponentRegistry.PANDORA_BOX, tags);
        return true;
    }

    public boolean release(Player player, Level worldIn, ItemStack stack) {
        if (player.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (stack.has(DataComponentRegistry.PANDORA_BOX)) {
            List tags = (List)stack.get(DataComponentRegistry.PANDORA_BOX);
            for (int i = 0; i < tags.size(); ++i) {
                AbstractSpellCastingPet pet;
                CompoundTag nbt = (CompoundTag)tags.get(i);
                Entity entity = this.getEntityFromStack(nbt, worldIn, true);
                if (entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && !pet.getSummoner().is((Entity)player)) {
                    return false;
                }
                float currentHealth = nbt.getFloat("currentHealthPet");
                if (entity instanceof AbstractSpellCastingPet) {
                    AbstractSpellCastingPet pet2 = (AbstractSpellCastingPet)entity;
                    pet2.setHealth(currentHealth);
                }
                float yrot = 6.281f / (float)tags.size() * (float)i + entity.getYRot() * ((float)Math.PI / 180);
                Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)worldIn, (Vec3)player.getEyePosition().add(new Vec3((double)(5.0f * Mth.cos((float)yrot)), 0.0, (double)(5.0f * Mth.sin((float)yrot)))), (int)10);
                entity.setPos(spawn.x, spawn.y, spawn.z);
                entity.setYRot(entity.getYRot());
                entity.setOldPosAndRot();
                worldIn.addFreshEntity(entity);
            }
            stack.remove(DataComponentRegistry.PANDORA_BOX);
            return true;
        }
        return false;
    }

    @Nullable
    public Entity getEntityFromStack(CompoundTag nbt, Level world, boolean withInfo) {
        EntityType type = EntityType.byString((String)nbt.getString("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(nbt);
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        int numPets = 0;
        if (itemStack.has(DataComponentRegistry.PANDORA_BOX)) {
            List tags = (List)itemStack.get(DataComponentRegistry.PANDORA_BOX);
            numPets = tags.size();
        }
        lines.add((Component)Component.literal((String)("Stored familiars: " + numPets)).withStyle(ChatFormatting.AQUA));
    }
}

