/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.sound;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HealingCircleEntity
extends AoeEntity
implements GeoEntity {
    private int effectAmplifier;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private DamageSource damageSource;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HealingCircleEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HealingCircleEntity(Level level, int effectAmplifier, LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.HEALING_CIRCLE.get()), level);
        this.effectAmplifier = effectAmplifier;
        this.setOwner(owner);
    }

    public void applyEffect(LivingEntity target) {
    }

    public void tick() {
        super.tick();
        if (this.getOwner() != null && this.tickCount % 5 == 0) {
            int radiusSqr = 16;
            this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.position().subtract(4.0, 4.0, 4.0), this.position().add(4.0, 4.0, 4.0)), livingEntity -> this.horizontalDistanceSqr((LivingEntity)livingEntity, this.position()) < (float)radiusSqr && (Utils.shouldHealEntity((LivingEntity)this.getOwner(), (LivingEntity)livingEntity) || livingEntity.is((Entity)this.getOwner())) && !livingEntity.hasEffect(MobEffects.REGENERATION)).forEach(livingEntity -> {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, Math.min(2, this.effectAmplifier), false, false, true));
                livingEntity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.OAKSKIN, 100, this.effectAmplifier, false, false, true));
            });
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.hasUUID("Owner")) {
            this.ownerUUID = pCompound.getUUID("Owner");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.ownerUUID != null) {
            pCompound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level instanceof ServerLevel && (entity = ((ServerLevel)this.level).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate));
    }

    private PlayState idlePredicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

