/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractFlyingSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SummonerPetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/summoner_pet.png");

    public SummonerPetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 80, 120).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), (AbstractSpell)SpellRegistry.SCULK_TENTACLES_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.TELEPORT_SPELL.get()), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell(PetSpellRegistry.SUMMON_SHADOW.get(), 200, 400, 1, 4).setIsFlying());
        this.goalSelector.addGoal(3, (Goal)new DisableSculkShriekerGoal(this, this::getSummoner, 10));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof DisableSculkShriekerGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 120, 180).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.SONIC_BOOM_SPELL.get(), (AbstractSpell)SpellRegistry.SCULK_TENTACLES_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.TELEPORT_SPELL.get()), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell(PetSpellRegistry.SUMMON_SHADOW.get(), 200, 400, 1, 4));
        this.goalSelector.addGoal(3, (Goal)new DisableSculkShriekerGoal(this, this::getSummoner, 10));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is((Item)ItemRegistry.LOST_KNOWLEDGE_FRAGMENT.get());
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSummoner() != null && this.tickCount % 5 == 0 && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
            if (this.getSummoner().hasEffect(MobEffects.NIGHT_VISION)) {
                if (this.getSummoner().getEffect(MobEffects.NIGHT_VISION).getDuration() < 500) {
                    this.getSummoner().addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 500 - this.getSummoner().getEffect(MobEffects.NIGHT_VISION).getDuration(), 0, false, false, true));
                }
            } else {
                this.getSummoner().addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 500, 0, false, false, true));
            }
            if (this.getSummoner().hasEffect(MobEffects.BLINDNESS)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().removeEffect(MobEffects.BLINDNESS);
            }
            if (this.getSummoner().hasEffect(MobEffects.DARKNESS)) {
                this.triggerAnim("interact_controller", "interact");
                this.getSummoner().removeEffect(MobEffects.DARKNESS);
            }
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_SUMMONER_TRIGGER.get())).trigger(player);
    }

    protected class DisableSculkShriekerGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int radius;

        public DisableSculkShriekerGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int radius) {
            this.controllerEntity = controllerEntity;
            this.targetEntity = targetEntity;
            this.radius = radius;
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            LivingEntity owner = this.targetEntity.get();
            BlockPos controllerPos = owner.blockPosition();
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int y = -this.radius; y <= this.radius; ++y) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        BlockPos currentPos = controllerPos.offset(x, y, z);
                        BlockState blockState = this.controllerEntity.level().getBlockState(currentPos);
                        if (!blockState.is(Blocks.SCULK_SHRIEKER) || !((Boolean)blockState.getValue((Property)SculkShriekerBlock.SHRIEKING)).booleanValue()) continue;
                        SummonerPetEntity.this.triggerAnim("interact_controller", "interact");
                        CylinderParticleManager.spawnParticlesAtBlockPos(owner.level(), currentPos.getCenter(), 50, (ParticleOptions)ParticleRegistry.FIREFLY_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.5, 0.0, 0.0);
                        this.controllerEntity.level().setBlock(currentPos, (BlockState)blockState.setValue((Property)SculkShriekerBlock.SHRIEKING, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
            }
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }
}

