/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class NecromancerPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/necromancer_pet.png");

    public NecromancerPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 60, 100).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get()), List.of(), List.of(), List.of((AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get(), 2000, 3000, 1, 4));
        this.goalSelector.addGoal(2, (Goal)new UndeadChaosGoal(this, this::getSummoner, 10.0, 100));
        this.goalSelector.addGoal(10, (Goal)new WitherifyGoal(this));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof UndeadChaosGoal || goal instanceof WitherifyGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 60, 100).setSpells(List.of((AbstractSpell)SpellRegistry.DEVOUR_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_NEEDLES_SPELL.get(), (AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get()), List.of(), List.of(), List.of((AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAISE_DEAD_SPELL.get(), 2000, 3000, 1, 4));
        this.goalSelector.addGoal(2, (Goal)new UndeadChaosGoal(this, this::getSummoner, 10.0, 100));
        this.goalSelector.addGoal(10, (Goal)new WitherifyGoal(this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is((Item)ItemRegistry.BLOOD_VIAL.get()) || item.is(Items.BONE);
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_NECROMANCER_TRIGGER.get())).trigger(player);
    }

    protected class UndeadChaosGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<LivingEntity> petOwner;
        private final double range;
        private final int interval;
        private int tickCounter;

        public UndeadChaosGoal(AbstractSpellCastingPet pet, Supplier<LivingEntity> owner, double range, int interval) {
            this.pet = pet;
            this.petOwner = owner;
            this.range = range;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean canUse() {
            LivingEntity owner = this.petOwner.get();
            if (owner == null) {
                return false;
            }
            return ++this.tickCounter >= this.interval;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.tickCounter = 0;
            NecromancerPetEntity.this.triggerAnim("interact_controller", "interact");
            Level level = this.pet.level();
            if (level.isClientSide) {
                return;
            }
            LivingEntity owner = this.petOwner.get();
            List undeadEntities = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(this.range), entity -> entity != this.pet && entity != owner && entity.getType().is(EntityTypeTags.UNDEAD) && !entity.getType().is(ModTags.NECROMANCER_BLACKLIST));
            if (undeadEntities.isEmpty()) {
                return;
            }
            List potentialTargets = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(this.range), entity -> entity != this.pet && entity != owner);
            if (potentialTargets.isEmpty()) {
                return;
            }
            for (LivingEntity undead : undeadEntities) {
                if (!(undead instanceof Mob)) continue;
                Mob mob = (Mob)undead;
                if (undead instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)undead;
                    if (summon.getSummoner() == null || summon.getSummoner() == owner || summon.getSummoner() == this.pet) continue;
                    this.selectTarget(potentialTargets, mob);
                    continue;
                }
                this.selectTarget(potentialTargets, mob);
            }
        }

        private void selectTarget(List<LivingEntity> potentialTargets, Mob mob) {
            ArrayList<LivingEntity> localTargets = new ArrayList<LivingEntity>(potentialTargets);
            localTargets.remove(mob);
            if (!localTargets.isEmpty()) {
                Random random = new Random();
                LivingEntity randomTarget = (LivingEntity)localTargets.get(random.nextInt(localTargets.size()));
                mob.setTarget(randomTarget);
            }
        }
    }

    protected class WitherifyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Skeleton skeleton;

        public WitherifyGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.skeleton != null) {
                return false;
            }
            this.skeleton = this.pet.level().getEntitiesOfClass(Skeleton.class, this.pet.getBoundingBox().inflate(15.0)).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.skeleton != null;
        }

        public boolean canContinueToUse() {
            return this.skeleton != null && this.skeleton.isAlive();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.skeleton, 1.0);
        }

        public void tick() {
            if (this.skeleton == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.skeleton) < 3.0) {
                this.pet.getLookControl().setLookAt((Entity)this.skeleton, 10.0f, 10.0f);
                NecromancerPetEntity.this.triggerAnim("interact_controller", "interact");
                WitherSkeleton witherSkeleton = new WitherSkeleton(EntityType.WITHER_SKELETON, this.pet.level());
                witherSkeleton.setPos(this.skeleton.getX(), this.skeleton.getY(), this.skeleton.getZ());
                witherSkeleton.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.pet.level()), this.pet.level.getCurrentDifficultyAt(this.skeleton.getOnPos()), MobSpawnType.MOB_SUMMONED, null);
                this.pet.level().addFreshEntity((Entity)witherSkeleton);
                MagicManager.spawnParticles((Level)NecromancerPetEntity.this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ELDRITCH.get()).getTargetingColor(), 2.0f), (double)this.skeleton.getX(), (double)(this.skeleton.getY() + (double)0.165f), (double)this.skeleton.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                this.skeleton.remove(Entity.RemovalReason.DISCARDED);
            } else {
                this.pet.getNavigation().moveTo((Entity)this.skeleton, 1.0);
            }
        }

        public void stop() {
            this.skeleton = null;
        }
    }
}

