/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractFlyingSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MagePetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/mage_pet.png");

    public MagePetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
        this.setRandomImpostor();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_LIGHTNING_SPELL.get()), List.of((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get()), List.of(), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.LIGHTNING_BOLT_SPELL.get(), 160, 300, 5, 8).setIsFlying());
        this.goalSelector.addGoal(2, (Goal)new AbstractSpellCastingPet.ApplyRandomEffectGoal(this, this::getSummoner, List.of(new MobEffectInstance((Holder)MobEffectRegistry.CHARGED, 200, 1, false, false)), 600));
        this.goalSelector.addGoal(10, (Goal)new ThunderstrikeGoal(this));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof AbstractSpellCastingPet.ApplyRandomEffectGoal || goal instanceof ThunderstrikeGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.BALL_LIGHTNING_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_LIGHTNING_SPELL.get()), List.of((AbstractSpell)SpellRegistry.SHOCKWAVE_SPELL.get()), List.of(), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.LIGHTNING_BOLT_SPELL.get(), 160, 300, 5, 8));
        this.goalSelector.addGoal(2, (Goal)new AbstractSpellCastingPet.ApplyRandomEffectGoal(this, this::getSummoner, List.of(new MobEffectInstance((Holder)MobEffectRegistry.CHARGED, 200, 1, false, false)), 600));
        this.goalSelector.addGoal(10, (Goal)new ThunderstrikeGoal(this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.FLYING_SPEED, (double)0.15f).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is((Item)ItemRegistry.LIGHTNING_BOTTLE.get());
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.LIGHTNING.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_MAGE_TRIGGER.get())).trigger(player);
    }

    protected class ThunderstrikeGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Creeper creeper;

        public ThunderstrikeGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.creeper != null) {
                return false;
            }
            this.creeper = this.pet.level().getEntitiesOfClass(Creeper.class, this.pet.getBoundingBox().inflate(15.0), creeper -> !creeper.isPowered()).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.creeper != null;
        }

        public boolean canContinueToUse() {
            return this.creeper != null && this.creeper.isAlive() && !this.creeper.isPowered();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.creeper, 1.0);
        }

        public void tick() {
            if (this.creeper == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.creeper) < 8.0) {
                this.pet.getLookControl().setLookAt((Entity)this.creeper, 10.0f, 10.0f);
                if (!this.creeper.isPowered()) {
                    MagePetEntity.this.triggerAnim("interact_controller", "interact");
                    LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(MagePetEntity.this.level);
                    lightningBolt.setVisualOnly(true);
                    lightningBolt.setDamage(0.0f);
                    lightningBolt.setPos(this.creeper.getX(), this.creeper.getY(), this.creeper.getZ());
                    MagePetEntity.this.level.addFreshEntity((Entity)lightningBolt);
                    this.creeper.thunderHit((ServerLevel)MagePetEntity.this.level, lightningBolt);
                }
            } else {
                this.pet.getNavigation().moveTo((Entity)this.creeper, 1.0);
            }
        }

        public void stop() {
            this.creeper = null;
        }
    }
}

