/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.misc.IllusionistDecoy;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IllusionistPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/illusionist_pet.png");

    public IllusionistPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 2000, 3000, 1, 4));
        this.goalSelector.addGoal(2, (Goal)new DecoyGoal(this, 200));
        this.goalSelector.addGoal(3, (Goal)new AbstractSpellCastingPet.StealItemsWhenNotWatchedGoal(this, this, 3.0));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof DecoyGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 2000, 3000, 1, 4));
        this.goalSelector.addGoal(2, (Goal)new DecoyGoal(this, 200));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is(Items.GOLD_NUGGET);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSummoner() != null && this.tickCount % 5 == 0 && (double)this.getSummoner().getHealth() < (double)this.getSummoner().getMaxHealth() * 0.25 && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
            if (this.getSummoner().hasEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY)) {
                if (this.getSummoner().getEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY).getDuration() < 500) {
                    this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 500 - this.getSummoner().getEffect((Holder)MobEffectRegistry.TRUE_INVISIBILITY).getDuration(), 0, false, false, true));
                }
            } else {
                this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 500, 0, false, false, true));
            }
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_ILLUSIONIST_TRIGGER.get())).trigger(player);
    }

    protected class DecoyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final int interval;
        private int tickCounter;

        public DecoyGoal(AbstractSpellCastingPet pet, int interval) {
            this.pet = pet;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean canUse() {
            return ++this.tickCounter >= this.interval && this.pet.getHealth() <= this.pet.getMaxHealth() / 2.0f;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.tickCounter = 0;
            IllusionistPetEntity.this.triggerAnim("interact_controller", "interact");
            Level level = this.pet.level();
            if (level.isClientSide) {
                return;
            }
            this.pet.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 100, 0, false, false, true));
            this.pet.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 5, false, false, true));
            IllusionistDecoy decoy = new IllusionistDecoy(this.pet.level(), (LivingEntity)this.pet);
            decoy.moveTo(this.pet.position());
            decoy.setYRot(this.pet.getYRot());
            this.pet.level().addFreshEntity((Entity)decoy);
        }
    }
}

