/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class HunterPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/hunter_pet.png");

    public HunterPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
        this.setRandomImpostor();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get(), (AbstractSpell)SpellRegistry.FIRE_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.ARROW_VOLLEY_SPELL.get(), 150, 300, 3, 6));
        this.targetSelector.addGoal(4, (Goal)new TargetAttackerOfPlayersGoal(this, this, this::getSummoner));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof TargetAttackerOfPlayersGoal || goal instanceof NearestAttackableTargetGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.ARROW_VOLLEY_SPELL.get(), 150, 300, 3, 6));
        this.targetSelector.addGoal(4, (Goal)new TargetAttackerOfPlayersGoal(this, this, this::getSummoner));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.4);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is(ItemTags.WOLF_FOOD);
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getSummoner() != null && this.getSummoner().is((Entity)player) && itemstack.is(Items.STICK)) {
            this.setSitting(this.getIsSitting() == false);
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide) {
            if (this.getOwnerUUID() != null) {
                if (this.getOwnerUUID().equals(player.getUUID())) {
                    this.triggerAnim("interact_controller", "interact");
                    if (itemstack.is((Item)ItemRegistry.BLUEBERRY.get())) {
                        itemstack.shrink(1);
                        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MEMORY_FRAGMENT.get());
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.heal(4.0f);
                            this.gameEvent((Holder)GameEvent.EAT);
                        }
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                        this.heal(4.0f);
                        itemstack.consume(1, (LivingEntity)player);
                        this.spawnEatingParticles();
                        this.gameEvent((Holder)GameEvent.EAT);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    if (itemstack != null && itemstack != ItemStack.EMPTY) {
                        Item heldItem = itemstack.getItem();
                        AABB searchArea = this.getBoundingBox().inflate(20.0);
                        List nearbyEntities = this.level().getEntities((Entity)this, searchArea, entity -> entity instanceof LivingEntity && this.canDropItem((ServerLevel)this.level(), (Entity)entity, heldItem));
                        for (Entity entity2 : nearbyEntities) {
                            if (!(entity2 instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity2;
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0, false, true));
                        }
                        return super.mobInteract(player, hand);
                    }
                }
            } else if (itemstack.is(ModTags.FAMILIAR_TAMING)) {
                itemstack.consume(1, (LivingEntity)player);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    private boolean canDropItem(ServerLevel level, Entity entity, Item searchItem) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ResourceKey lootTableId = livingEntity.getLootTable();
        if (lootTableId == null) {
            return false;
        }
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableId);
        LootParams params = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic()).create(LootContextParamSets.ENTITY);
        ObjectArrayList generatedItems = lootTable.getRandomItems(params);
        return generatedItems.stream().anyMatch(stack -> stack.getItem() == searchItem);
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_HUNTER_TRIGGER.get())).trigger(player);
    }

    public class TargetAttackerOfPlayersGoal
    extends TargetGoal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<LivingEntity> owner;
        private LivingEntity target;

        public TargetAttackerOfPlayersGoal(HunterPetEntity this$0, AbstractSpellCastingPet pet, Supplier<LivingEntity> owner) {
            super((Mob)pet, true);
            this.pet = pet;
            this.owner = owner;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity getOwner = this.owner.get();
            if (getOwner == null) {
                return false;
            }
            Level level = this.pet.level();
            List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(15.0), entity -> {
                Mob mob;
                return entity instanceof Mob && (mob = (Mob)entity).getTarget() == getOwner;
            });
            if (!nearbyEntities.isEmpty()) {
                this.target = (LivingEntity)nearbyEntities.getFirst();
                return true;
            }
            return false;
        }

        public void start() {
            this.pet.setTarget(this.target);
            this.pet.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)this.target, 200L);
            super.start();
        }
    }
}

