/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.compat;

import io.redspace.ironsspellbooks.registries.BlockRegistry;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.util.rituals.RitualHelper;
import net.alshanex.alshanex_familiars.util.rituals.RitualRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import oshi.util.tuples.Pair;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("alshanex_familiars", "ritual_casting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("alshanex_familiars", "textures/gui/ritual_recipe_gui.png");
    public static final RecipeType<RitualRecipe> RITUAL_RECIPE_TYPE = new RecipeType(UID, RitualRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final List<Pair<Integer, Integer>> INPUT_COORDINATES = List.of(new Pair((Object)80, (Object)11), new Pair((Object)50, (Object)41), new Pair((Object)110, (Object)41), new Pair((Object)80, (Object)71));
    private static final Pair<Integer, Integer> CENTER_COORDINATES = new Pair((Object)80, (Object)41);
    private static final Pair<Integer, Integer> OUTPUT_COORDINATES = new Pair((Object)80, (Object)116);

    public RitualRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 146);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.PEDESTAL_BLOCK.get()));
    }

    public RecipeType<RitualRecipe> getRecipeType() {
        return RITUAL_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"ui.alshanex_familiars.ritual_recipe_jei");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        int ingredientsToShow = Math.min(ingredients.size(), INPUT_COORDINATES.size());
        for (int i = 0; i < ingredientsToShow; ++i) {
            Pair<Integer, Integer> coordinates = INPUT_COORDINATES.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)coordinates.getA()).intValue(), ((Integer)coordinates.getB()).intValue()).addIngredients((Ingredient)ingredients.get(i));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)CENTER_COORDINATES.getA()).intValue(), ((Integer)CENTER_COORDINATES.getB()).intValue()).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)recipe.getCentralItem())}));
        Item resultItem = RitualHelper.getRitualRecipes().get(recipe);
        if (resultItem != null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)OUTPUT_COORDINATES.getA()).intValue(), ((Integer)OUTPUT_COORDINATES.getB()).intValue()).addItemStack(new ItemStack((ItemLike)resultItem));
        } else {
            AlshanexFamiliarsMod.LOGGER.warn("No result found for ritual recipe: {}", (Object)recipe);
        }
    }
}

