/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import javax.annotation.Nonnull;
import net.alshanex.alshanex_familiars.block.PetBedBlock;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.item.curios.AbstractFamiliarTrinket;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.screen.PetBedMenu;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PetBedBlockEntity
extends BlockEntity
implements MenuProvider {
    private PetBedMenu menu;
    private DyeColor color = DyeColor.WHITE;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PetBedBlockEntity.this.setChanged();
            if (!((PetBedBlockEntity)PetBedBlockEntity.this).level.isClientSide) {
                PetBedBlockEntity.this.level.sendBlockUpdated(PetBedBlockEntity.this.getBlockPos(), PetBedBlockEntity.this.getBlockState(), PetBedBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private int counter = 0;

    public PetBedBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.PET_BED.get(), pos, state);
        if (state.hasProperty(PetBedBlock.COLOR)) {
            this.color = (DyeColor)state.getValue(PetBedBlock.COLOR);
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
        this.setChanged();
        if (!this.level.isClientSide) {
            BlockState currentState = this.getBlockState();
            if (currentState.hasProperty(PetBedBlock.COLOR) && currentState.getValue(PetBedBlock.COLOR) != color) {
                this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue(PetBedBlock.COLOR, (Comparable)color), 3);
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Familiar Bed");
    }

    public ItemStack getRenderStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        this.menu = new PetBedMenu(containerId, playerInventory, this);
        return this.menu;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("inventory")) {
            this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        }
        if (pTag.contains("color")) {
            BlockState state;
            this.color = DyeColor.byName((String)pTag.getString("color"), (DyeColor)DyeColor.WHITE);
            if (this.level != null && this.hasLevel() && (state = this.level.getBlockState(this.worldPosition)).hasProperty(PetBedBlock.COLOR) && state.getValue(PetBedBlock.COLOR) != this.color) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue(PetBedBlock.COLOR, (Comparable)this.color), 3);
            }
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registryAccess) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registryAccess));
        tag.putString("Color", this.color.getName());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.putString("Color", this.color.getName());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack != null && stack != ItemStack.EMPTY && (stack.is((Item)ItemRegistry.FAMILIAR_TOME.get()) || stack.getItem() instanceof AbstractFamiliarTrinket)) {
            boolean isSummoned;
            CompoundTag nbt;
            if (stack.has(DataComponentRegistry.FAMILIAR_TOME)) {
                nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME);
                float maxHealth = nbt.getFloat("currentHealth");
                Entity entity = this.getEntityFromStack(stack, pLevel, true);
                if (entity != null && entity instanceof AbstractSpellCastingPet) {
                    AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity;
                    maxHealth = pet.getMaxHealth();
                }
                float currentHealth = nbt.getFloat("currentHealth");
                ++this.counter;
                if (this.counter % 20 == 0) {
                    CylinderParticleManager.spawnParticlesAtBlockPos(pLevel, pPos.getCenter(), 1, (ParticleOptions)ParticleRegistry.SLEEP_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.0, 0.8);
                }
                if (this.counter >= 40) {
                    if (currentHealth < maxHealth) {
                        nbt.putFloat("currentHealth", currentHealth += 1.0f);
                    }
                    this.counter = 0;
                }
            }
            if (stack.has(DataComponentRegistry.FAMILIAR_TRINKET) && !(isSummoned = (nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET)).getBoolean("isSummoned"))) {
                float maxHealth = nbt.getFloat("currentHealth");
                Entity entity = this.getEntityFromStack(stack, pLevel, true);
                if (entity != null && entity instanceof AbstractSpellCastingPet) {
                    AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity;
                    maxHealth = pet.getMaxHealth();
                }
                float currentHealth = nbt.getFloat("currentHealth");
                ++this.counter;
                if (this.counter % 20 == 0) {
                    CylinderParticleManager.spawnParticlesAtBlockPos(pLevel, pPos.getCenter(), 1, (ParticleOptions)ParticleRegistry.SLEEP_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.0, 0.8);
                }
                if (this.counter >= 40) {
                    if (currentHealth < maxHealth) {
                        nbt.putFloat("currentHealth", currentHealth += 1.0f);
                    }
                    this.counter = 0;
                }
            }
        }
    }

    @javax.annotation.Nullable
    public Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        CompoundTag nbt;
        EntityType type;
        if (stack.has(DataComponentRegistry.FAMILIAR_TOME) && (type = (EntityType)EntityType.byString((String)(nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME)).getString("entity")).orElse(null)) != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(nbt);
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        if (stack.has(DataComponentRegistry.FAMILIAR_TRINKET) && (type = (EntityType)EntityType.byString((String)(nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET)).getString("entity")).orElse(null)) != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(nbt);
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        return null;
    }
}

