/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block;

import io.redspace.ironsspellbooks.block.pedestal.PedestalBlock;
import net.alshanex.alshanex_familiars.block.entity.RitualCorePedestalEntity;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualCorePedestal
extends PedestalBlock {
    private static final VoxelShape LEG1 = Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)4.0, (double)10.0);
    private static final VoxelShape LEG2 = Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)4.0, (double)16.0);
    private static final VoxelShape LEG3 = Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0);
    private static final VoxelShape LEG4 = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)4.0);
    private static final VoxelShape SECOND_LEG1 = Block.box((double)5.5, (double)0.0, (double)11.0, (double)10.5, (double)5.0, (double)16.0);
    private static final VoxelShape SECOND_LEG2 = Block.box((double)5.5, (double)0.0, (double)0.0, (double)10.5, (double)5.0, (double)5.0);
    private static final VoxelShape SECOND_LEG3 = Block.box((double)11.0, (double)0.0, (double)5.5, (double)16.0, (double)5.0, (double)10.5);
    private static final VoxelShape SECOND_LEG4 = Block.box((double)0.0, (double)0.0, (double)5.5, (double)5.0, (double)5.0, (double)10.5);
    private static final VoxelShape CENTER = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape TOP = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)LEG1, (VoxelShape[])new VoxelShape[]{LEG2, LEG3, LEG4, SECOND_LEG1, SECOND_LEG2, SECOND_LEG3, SECOND_LEG4, CENTER, TOP});

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof RitualCorePedestalEntity) {
            ((RitualCorePedestalEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualCorePedestalEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState state, Level pLevel, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!pLevel.isClientSide() && (entity = pLevel.getBlockEntity(pos)) instanceof RitualCorePedestalEntity) {
            RitualCorePedestalEntity pedestalTile = (RitualCorePedestalEntity)entity;
            ItemStack currentPedestalItem = pedestalTile.getHeldItem();
            ItemStack handItem = player.getItemInHand(hand);
            ItemStack playerItem = currentPedestalItem.copy();
            if (handItem.isEmpty() || handItem.getCount() == 1) {
                player.setItemInHand(hand, playerItem);
            } else {
                this.dropItem(playerItem, player);
            }
            pedestalTile.setHeldItem(ItemStack.EMPTY);
            currentPedestalItem = handItem.copy();
            if (!currentPedestalItem.isEmpty()) {
                currentPedestalItem.setCount(1);
                pedestalTile.setHeldItem(currentPedestalItem);
                handItem.shrink(1);
            }
            pLevel.sendBlockUpdated(pos, state, state, 2);
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    private void dropItem(ItemStack itemstack, Player owner) {
        ServerPlayer serverplayer;
        ItemEntity itementity;
        if (owner instanceof ServerPlayer && (itementity = (serverplayer = (ServerPlayer)owner).drop(itemstack, false)) != null) {
            itementity.setNoPickUpDelay();
            itementity.setThrower((Entity)owner);
        }
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public float defaultDestroyTime() {
        return Float.MAX_VALUE;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return RitualCorePedestal.createTickerHelper(blockEntityType, BlockEntityRegistry.RITUAL_CORE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }
}

