/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.alshanex.alshanex_familiars.block.entity.PetBedBlockEntity;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PetBedBlock
extends BaseEntityBlock {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape PART_1 = PetBedBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0);
    private static final VoxelShape PART_2 = PetBedBlock.box((double)0.0, (double)5.0, (double)13.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape PART_3 = PetBedBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    private static final VoxelShape PART_4 = PetBedBlock.box((double)13.0, (double)5.0, (double)3.0, (double)16.0, (double)7.0, (double)13.0);
    private static final VoxelShape PART_5 = PetBedBlock.box((double)0.0, (double)5.0, (double)3.0, (double)3.0, (double)7.0, (double)13.0);
    private static final VoxelShape PART_6 = PetBedBlock.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape PART_7 = PetBedBlock.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0);
    private static final VoxelShape PART_8 = PetBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)2.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)PART_1, (VoxelShape[])new VoxelShape[]{PART_2, PART_3, PART_4, PART_5, PART_6, PART_7, PART_8});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)PetBedBlock.rotateBox(PART_1, Rotation.CLOCKWISE_180), (VoxelShape[])new VoxelShape[]{PetBedBlock.rotateBox(PART_2, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_3, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_4, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_5, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_6, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_7, Rotation.CLOCKWISE_180), PetBedBlock.rotateBox(PART_8, Rotation.CLOCKWISE_180)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)PetBedBlock.rotateBox(PART_1, Rotation.CLOCKWISE_90), (VoxelShape[])new VoxelShape[]{PetBedBlock.rotateBox(PART_2, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_3, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_4, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_5, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_6, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_7, Rotation.CLOCKWISE_90), PetBedBlock.rotateBox(PART_8, Rotation.CLOCKWISE_90)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)PetBedBlock.rotateBox(PART_1, Rotation.COUNTERCLOCKWISE_90), (VoxelShape[])new VoxelShape[]{PetBedBlock.rotateBox(PART_2, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_3, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_4, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_5, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_6, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_7, Rotation.COUNTERCLOCKWISE_90), PetBedBlock.rotateBox(PART_8, Rotation.COUNTERCLOCKWISE_90)});
    public static final MapCodec<PetBedBlock> CODEC = PetBedBlock.simpleCodec(PetBedBlock::new);

    public PetBedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COLOR});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(COLOR, (Comparable)DyeColor.WHITE);
    }

    public BlockState setColor(BlockState state, DyeColor color) {
        return (BlockState)state.setValue(COLOR, (Comparable)color);
    }

    private static VoxelShape rotateBox(VoxelShape shape, Rotation rotation) {
        List boxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : boxes) {
            double x1 = box.minX;
            double y1 = box.minY;
            double z1 = box.minZ;
            double x2 = box.maxX;
            double y2 = box.maxY;
            double z2 = box.maxZ;
            rotatedShape = Shapes.or((VoxelShape)rotatedShape, (VoxelShape)(switch (rotation) {
                case Rotation.CLOCKWISE_90 -> Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2);
                case Rotation.CLOCKWISE_180 -> Shapes.box((double)(1.0 - x2), (double)y1, (double)(1.0 - z2), (double)(1.0 - x1), (double)y2, (double)(1.0 - z1));
                case Rotation.COUNTERCLOCKWISE_90 -> Shapes.box((double)z1, (double)y1, (double)(1.0 - x2), (double)z2, (double)y2, (double)(1.0 - x1));
                default -> Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }));
        }
        return rotatedShape;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public MapCodec<PetBedBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PetBedBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof PetBedBlockEntity) {
            ((PetBedBlockEntity)blockEntity).drops();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        pPlayer.openMenu(pState.getMenuProvider(pLevel, pPos), buf -> buf.writeBlockPos(pPos));
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)stack.getItem()).getDyeColor();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof PetBedBlockEntity) {
                PetBedBlockEntity petBed = (PetBedBlockEntity)blockEntity;
                if (state.getValue(COLOR) == dyeColor) {
                    return ItemInteractionResult.FAIL;
                }
                if (!level.isClientSide) {
                    level.setBlock(pos, (BlockState)state.setValue(COLOR, (Comparable)dyeColor), 3);
                    petBed.setColor(dyeColor);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState pState, Level pLevel, BlockPos pPos) {
        return new SimpleMenuProvider((i, inventory, player) -> ((PetBedBlockEntity)pLevel.getBlockEntity(pPos)).createMenu(i, inventory, player), (Component)Component.translatable((String)"block.magic_pets.pet_bed"));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return PetBedBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.PET_BED.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }
}

