/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.treedecorator;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGTreeDecoratorTypes;

public class GrongleLeafDecorator
extends TreeDecorator {
    public static final GrongleLeafDecorator INSTANCE = new GrongleLeafDecorator();
    public static final MapCodec<GrongleLeafDecorator> CODEC = MapCodec.unit(() -> INSTANCE);

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)UGTreeDecoratorTypes.GRONGLE_LEAF_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        context.leaves().forEach(pos -> {
            if (random.nextInt(3) == 0) {
                BlockPos downPos = pos.below();
                BlockPos down2Pos = downPos.below();
                if (context.isAir(downPos) && context.isAir(down2Pos)) {
                    context.setBlock(downPos, ((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get()).defaultBlockState());
                    context.setBlock(down2Pos, (BlockState)((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get()).defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
                }
            }
        });
    }
}

