/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import quek.undergarden.registry.UGBlocks;

public class SmogVentFeature
extends Feature<NoneFeatureConfiguration> {
    public SmogVentFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        while (level.isEmptyBlock(pos) && pos.getY() > 2) {
            pos = pos.below();
        }
        if (level.isEmptyBlock(pos.above(7))) {
            pos = pos.above(random.nextInt(4));
            int ventHeight = 7;
            int j = ventHeight / 4 + random.nextInt(2);
            for (int k = 0; k < ventHeight; ++k) {
                float f = (1.0f - (float)k / (float)ventHeight) * (float)j;
                int l = Mth.ceil((float)f);
                for (int i1 = -l; i1 <= l; ++i1) {
                    float f1 = (float)Mth.abs((int)i1) - 0.25f;
                    for (int j1 = -l; j1 <= l; ++j1) {
                        float f2 = (float)Mth.abs((int)j1) - 0.25f;
                        if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && random.nextFloat() > 0.75f) continue;
                        BlockState blockstate = level.getBlockState(pos.offset(i1, k, j1));
                        BlockPos ventPos = new BlockPos(pos.getX(), pos.getY() + 7, pos.getZ());
                        if (blockstate.isAir()) {
                            this.setBlock((LevelWriter)level, pos.offset(i1, k, j1), ((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState());
                        }
                        this.setBlock((LevelWriter)level, ventPos, ((Block)UGBlocks.SMOG_VENT.get()).defaultBlockState());
                        if (k == 0 || l <= 1 || !(blockstate = level.getBlockState(pos.offset(i1, -k, j1))).isAir()) continue;
                        this.setBlock((LevelWriter)level, pos.offset(i1, -k, j1), ((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState());
                    }
                }
            }
            int k1 = j - 1;
            for (int l1 = -k1; l1 <= k1; ++l1) {
                BlockPos blockpos;
                BlockState blockstate1;
                for (int i2 = -k1; i2 <= k1 && (blockstate1 = level.getBlockState(blockpos = pos.offset(l1, -1, i2))).isAir(); ++i2) {
                    level.setBlock(blockpos, ((Block)UGBlocks.DEPTHROCK.get()).defaultBlockState(), 1);
                }
            }
            return true;
        }
        return false;
    }
}

