/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGConfiguredFeatures;

public class UGPlacedFeatures {
    public static final ResourceKey<PlacedFeature> COAL_ORE = UGPlacedFeatures.create("coal_ore");
    public static final ResourceKey<PlacedFeature> IRON_ORE = UGPlacedFeatures.create("iron_ore");
    public static final ResourceKey<PlacedFeature> GOLD_ORE = UGPlacedFeatures.create("gold_ore");
    public static final ResourceKey<PlacedFeature> DIAMOND_ORE = UGPlacedFeatures.create("diamond_ore");
    public static final ResourceKey<PlacedFeature> CLOGGRUM_ORE = UGPlacedFeatures.create("cloggrum_ore");
    public static final ResourceKey<PlacedFeature> FROSTSTEEL_ORE = UGPlacedFeatures.create("froststeel_ore");
    public static final ResourceKey<PlacedFeature> UTHERIUM_ORE = UGPlacedFeatures.create("utherium_ore");
    public static final ResourceKey<PlacedFeature> REGALIUM_ORE = UGPlacedFeatures.create("regalium_ore");
    public static final ResourceKey<PlacedFeature> SHIVERSTONE_ORE = UGPlacedFeatures.create("shiverstone_ore");
    public static final ResourceKey<PlacedFeature> DEEPSOIL_ORE = UGPlacedFeatures.create("deepsoil_ore");
    public static final ResourceKey<PlacedFeature> ICE_ORE = UGPlacedFeatures.create("ice_ore");
    public static final ResourceKey<PlacedFeature> SEDIMENT_ORE = UGPlacedFeatures.create("sediment_ore");
    public static final ResourceKey<PlacedFeature> BOG_DELTA = UGPlacedFeatures.create("bog_delta");
    public static final ResourceKey<PlacedFeature> GRONGLEGROWTH_DELTA = UGPlacedFeatures.create("gronglegrowth_delta");
    public static final ResourceKey<PlacedFeature> AMOROUS_BRISTLE_PATCH = UGPlacedFeatures.create("amorous_bristle_patch");
    public static final ResourceKey<PlacedFeature> MISERABELL_PATCH = UGPlacedFeatures.create("miserabell_patch");
    public static final ResourceKey<PlacedFeature> BUTTERBUNCH_PATCH = UGPlacedFeatures.create("butterbunch_patch");
    public static final ResourceKey<PlacedFeature> DEEPTURF_PATCH = UGPlacedFeatures.create("deepturf_patch");
    public static final ResourceKey<PlacedFeature> ASHEN_DEEPTURF_PATCH = UGPlacedFeatures.create("ashen_deepturf_patch");
    public static final ResourceKey<PlacedFeature> FROZEN_DEEPTURF_PATCH = UGPlacedFeatures.create("frozen_deepturf_patch");
    public static final ResourceKey<PlacedFeature> SHIMMERWEED_PATCH = UGPlacedFeatures.create("shimmerweed_patch");
    public static final ResourceKey<PlacedFeature> DEPTHROCK_PEBBLE_PATCH = UGPlacedFeatures.create("depthrock_pebble_patch");
    public static final ResourceKey<PlacedFeature> DITCHBULB_PATCH = UGPlacedFeatures.create("ditchbulb_patch");
    public static final ResourceKey<PlacedFeature> TALL_DEEPTURF_PATCH = UGPlacedFeatures.create("tall_deepturf_patch");
    public static final ResourceKey<PlacedFeature> TALL_SHIMMERWEED_PATCH = UGPlacedFeatures.create("tall_shimmerweed_patch");
    public static final ResourceKey<PlacedFeature> INDIGO_MUSHROOM_PATCH = UGPlacedFeatures.create("indigo_mushroom_patch");
    public static final ResourceKey<PlacedFeature> VEIL_MUSHROOM_PATCH = UGPlacedFeatures.create("veil_mushroom_patch");
    public static final ResourceKey<PlacedFeature> INK_MUSHROOM_PATCH = UGPlacedFeatures.create("ink_mushroom_patch");
    public static final ResourceKey<PlacedFeature> BLOOD_MUSHROOM_PATCH = UGPlacedFeatures.create("blood_mushroom_patch");
    public static final ResourceKey<PlacedFeature> UNDERBEAN_BUSH_PATCH = UGPlacedFeatures.create("underbean_bush_patch");
    public static final ResourceKey<PlacedFeature> BLISTERBERRY_BUSH_PATCH = UGPlacedFeatures.create("blisterberry_bush_patch");
    public static final ResourceKey<PlacedFeature> GLOOMGOURD_PATCH = UGPlacedFeatures.create("gloomgourd_patch");
    public static final ResourceKey<PlacedFeature> DROOPVINE_PATCH = UGPlacedFeatures.create("droopvine_patch");
    public static final ResourceKey<PlacedFeature> GLITTERKELP_PATCH = UGPlacedFeatures.create("glitterkelp_patch");
    public static final ResourceKey<PlacedFeature> SMOGSTEM_TREE = UGPlacedFeatures.create("smogstem_tree");
    public static final ResourceKey<PlacedFeature> WIDE_SMOGSTEM_TREE = UGPlacedFeatures.create("wide_smogstem_tree");
    public static final ResourceKey<PlacedFeature> TALL_SMOGSTEM_TREE = UGPlacedFeatures.create("tall_smogstem_tree");
    public static final ResourceKey<PlacedFeature> SMOGSTEM_BUSH = UGPlacedFeatures.create("smogstem_bush");
    public static final ResourceKey<PlacedFeature> WIGGLEWOOD_TREE = UGPlacedFeatures.create("wigglewood_tree");
    public static final ResourceKey<PlacedFeature> TALL_WIGGLEWOOD_TREE = UGPlacedFeatures.create("tall_wigglewood_tree");
    public static final ResourceKey<PlacedFeature> GRONGLE_TREE = UGPlacedFeatures.create("grongle_tree");
    public static final ResourceKey<PlacedFeature> SMALL_GRONGLE_TREE = UGPlacedFeatures.create("small_grongle_tree");
    public static final ResourceKey<PlacedFeature> GRONGLE_BUSH = UGPlacedFeatures.create("grongle_bush");
    public static final ResourceKey<PlacedFeature> HUGE_INDIGO_MUSHROOM = UGPlacedFeatures.create("huge_indigo_mushroom");
    public static final ResourceKey<PlacedFeature> HUGE_INDIGO_MUSHROOM_SMOGSTEM_FOREST = UGPlacedFeatures.create("huge_indigo_mushroom_smogstem_forest");
    public static final ResourceKey<PlacedFeature> HUGE_VEIL_MUSHROOM = UGPlacedFeatures.create("huge_veil_mushroom");
    public static final ResourceKey<PlacedFeature> HUGE_INK_MUSHROOM = UGPlacedFeatures.create("huge_ink_mushroom");
    public static final ResourceKey<PlacedFeature> HUGE_BLOOD_MUSHROOM = UGPlacedFeatures.create("huge_blood_mushroom");
    public static final ResourceKey<PlacedFeature> DEPTHROCK_ROCK = UGPlacedFeatures.create("depthrock_rock");
    public static final ResourceKey<PlacedFeature> SHIVERSTONE_ROCK = UGPlacedFeatures.create("shiverstone_rock");
    public static final ResourceKey<PlacedFeature> SMOG_VENT = UGPlacedFeatures.create("smog_vent");
    public static final ResourceKey<PlacedFeature> ICE_PILLAR = UGPlacedFeatures.create("ice_pillar");

    public static ResourceKey<PlacedFeature> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(COAL_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.COAL_ORE), OrePlacements.commonOrePlacement((int)30, (PlacementModifier)PlacementUtils.FULL_RANGE)));
        context.register(IRON_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.IRON_ORE), OrePlacements.commonOrePlacement((int)8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.belowTop((int)64), (VerticalAnchor)VerticalAnchor.belowTop((int)-64)))));
        context.register(GOLD_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GOLD_ORE), OrePlacements.commonOrePlacement((int)2, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.belowTop((int)32), (VerticalAnchor)VerticalAnchor.belowTop((int)-32)))));
        context.register(DIAMOND_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DIAMOND_ORE), OrePlacements.commonOrePlacement((int)1, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.belowTop((int)16), (VerticalAnchor)VerticalAnchor.belowTop((int)-16)))));
        context.register(CLOGGRUM_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.CLOGGRUM_ORE), OrePlacements.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-128), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)))));
        context.register(FROSTSTEEL_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.FROSTSTEEL_ORE), OrePlacements.commonOrePlacement((int)15, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-128), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)))));
        context.register(UTHERIUM_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.UTHERIUM_ORE), OrePlacements.commonOrePlacement((int)3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)))));
        context.register(REGALIUM_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.REGALIUM_ORE), OrePlacements.commonOrePlacement((int)3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)12)))));
        context.register(SHIVERSTONE_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SHIVERSTONE_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)PlacementUtils.FULL_RANGE)));
        context.register(DEEPSOIL_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DEEPSOIL_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)PlacementUtils.FULL_RANGE)));
        context.register(ICE_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.ICE_ORE), OrePlacements.commonOrePlacement((int)20, (PlacementModifier)PlacementUtils.FULL_RANGE)));
        context.register(SEDIMENT_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SEDIMENT_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)32)))));
        context.register(BOG_DELTA, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.BOG_DELTA), List.of(CountOnEveryLayerPlacement.of((int)40), BiomeFilter.biome())));
        context.register(GRONGLEGROWTH_DELTA, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GRONGLEGROWTH_DELTA), List.of(CountOnEveryLayerPlacement.of((int)40), BiomeFilter.biome())));
        context.register(AMOROUS_BRISTLE_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.AMOROUS_BRISTLE_PATCH), UGPlacedFeatures.patch(5)));
        context.register(MISERABELL_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.MISERABELL_PATCH), UGPlacedFeatures.patch(5)));
        context.register(BUTTERBUNCH_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.BUTTERBUNCH_PATCH), UGPlacedFeatures.patch(5)));
        context.register(DEEPTURF_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DEEPTURF_PATCH), UGPlacedFeatures.patchWithFilter(100, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get()}))));
        context.register(ASHEN_DEEPTURF_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.ASHEN_DEEPTURF_PATCH), UGPlacedFeatures.patchWithFilter(100, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get()}))));
        context.register(FROZEN_DEEPTURF_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.FROZEN_DEEPTURF_PATCH), UGPlacedFeatures.patchWithFilter(100, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()}))));
        context.register(SHIMMERWEED_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SHIMMERWEED_PATCH), UGPlacedFeatures.noiseWithFilter(200, 75.0, 0.0, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPSOIL.get(), (Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()}))));
        context.register(DEPTHROCK_PEBBLE_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DEPTHROCK_PEBBLE_PATCH), UGPlacedFeatures.noise(200, 50.0, 0.0)));
        context.register(DITCHBULB_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DITCHBULB_PATCH), UGPlacedFeatures.patchWithFilter(75, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.DEPTHROCK.get()}))));
        context.register(TALL_DEEPTURF_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.TALL_DEEPTURF_PATCH), UGPlacedFeatures.patchWithFilter(100, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get()}))));
        context.register(TALL_SHIMMERWEED_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.TALL_SHIMMERWEED_PATCH), UGPlacedFeatures.noiseWithFilter(200, 75.0, 0.0, BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPSOIL.get(), (Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()}))));
        context.register(INDIGO_MUSHROOM_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.INDIGO_MUSHROOM_PATCH), UGPlacedFeatures.patch(1)));
        context.register(VEIL_MUSHROOM_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.VEIL_MUSHROOM_PATCH), UGPlacedFeatures.patch(1)));
        context.register(INK_MUSHROOM_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.INK_MUSHROOM_PATCH), UGPlacedFeatures.patch(1)));
        context.register(BLOOD_MUSHROOM_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.BLOOD_MUSHROOM_PATCH), UGPlacedFeatures.patch(1)));
        context.register(UNDERBEAN_BUSH_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.UNDERBEAN_BUSH_PATCH), UGPlacedFeatures.patch(5)));
        context.register(BLISTERBERRY_BUSH_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.BLISTERBERRY_BUSH_PATCH), UGPlacedFeatures.patch(5)));
        context.register(GLOOMGOURD_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GLOOMGOURD_PATCH), UGPlacedFeatures.patch(5)));
        context.register(DROOPVINE_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DROOPVINE), UGPlacedFeatures.patch(100)));
        context.register(GLITTERKELP_PATCH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GLITTERKELP), List.of(NoiseBasedCountPlacement.of((int)1000, (double)80.0, (double)0.0), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)31)), BiomeFilter.biome())));
        context.register(SMOGSTEM_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SMOGSTEM_TREE), UGPlacedFeatures.tree(8)));
        context.register(WIDE_SMOGSTEM_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.WIDE_SMOGSTEM_TREE), UGPlacedFeatures.tree(2)));
        context.register(TALL_SMOGSTEM_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.TALL_SMOGSTEM_TREE), UGPlacedFeatures.tree(4)));
        context.register(SMOGSTEM_BUSH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SMOGSTEM_BUSH), UGPlacedFeatures.tree(8)));
        context.register(WIGGLEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.WIGGLEWOOD_TREE), UGPlacedFeatures.tree(8)));
        context.register(TALL_WIGGLEWOOD_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.TALL_WIGGLEWOOD_TREE), UGPlacedFeatures.tree(4)));
        context.register(GRONGLE_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GRONGLE_TREE), UGPlacedFeatures.tree(8)));
        context.register(SMALL_GRONGLE_TREE, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SMALL_GRONGLE_TREE), UGPlacedFeatures.tree(8)));
        context.register(GRONGLE_BUSH, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.GRONGLE_BUSH), UGPlacedFeatures.tree(8)));
        context.register(HUGE_INDIGO_MUSHROOM, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.HUGE_INDIGO_MUSHROOM), UGPlacedFeatures.tree(8)));
        context.register(HUGE_INDIGO_MUSHROOM_SMOGSTEM_FOREST, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.HUGE_INDIGO_MUSHROOM), UGPlacedFeatures.tree(1)));
        context.register(HUGE_VEIL_MUSHROOM, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.HUGE_VEIL_MUSHROOM), UGPlacedFeatures.tree(8)));
        context.register(HUGE_INK_MUSHROOM, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.HUGE_INK_MUSHROOM), UGPlacedFeatures.tree(8)));
        context.register(HUGE_BLOOD_MUSHROOM, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.HUGE_BLOOD_MUSHROOM), UGPlacedFeatures.tree(8)));
        context.register(DEPTHROCK_ROCK, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.DEPTHROCK_ROCK), UGPlacedFeatures.patch(5)));
        context.register(SHIVERSTONE_ROCK, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SHIVERSTONE_ROCK), UGPlacedFeatures.patch(5)));
        context.register(SMOG_VENT, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.SMOG_VENT), UGPlacedFeatures.tree(8)));
        context.register(ICE_PILLAR, (Object)new PlacedFeature((Holder)features.getOrThrow(UGConfiguredFeatures.ICE_PILLAR), UGPlacedFeatures.patch(50)));
    }

    private static List<PlacementModifier> tree(int count) {
        return List.of(CountOnEveryLayerPlacement.of((int)count), BiomeFilter.biome(), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)Blocks.OAK_SAPLING.defaultBlockState(), (Vec3i)BlockPos.ZERO)));
    }

    private static List<PlacementModifier> patch(int count) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome());
    }

    private static List<PlacementModifier> patchWithFilter(int count, BlockPredicate filter) {
        return List.of(CountPlacement.of((int)count), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BlockPredicateFilter.forPredicate((BlockPredicate)filter), BiomeFilter.biome());
    }

    private static List<PlacementModifier> noise(int noiseToCountRatio, double factor, double offset) {
        return List.of(NoiseBasedCountPlacement.of((int)noiseToCountRatio, (double)factor, (double)offset), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome());
    }

    private static List<PlacementModifier> noiseWithFilter(int noiseToCountRatio, double factor, double offset, BlockPredicate filter) {
        return List.of(NoiseBasedCountPlacement.of((int)noiseToCountRatio, (double)factor, (double)offset), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BlockPredicateFilter.forPredicate((BlockPredicate)filter), BiomeFilter.biome());
    }
}

