/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.neoforge.registries.DeferredHolder;
import quek.undergarden.registry.UGSoundEvents;

public class UGJukeboxSongs {
    public static final ResourceKey<JukeboxSong> MAMMOTH = UGJukeboxSongs.create("mammoth");
    public static final ResourceKey<JukeboxSong> LIMAX_MAXIMUS = UGJukeboxSongs.create("limax_maximus");
    public static final ResourceKey<JukeboxSong> RELICT = UGJukeboxSongs.create("relict");
    public static final ResourceKey<JukeboxSong> GLOOMPER_ANTHEM = UGJukeboxSongs.create("gloomper_anthem");
    public static final ResourceKey<JukeboxSong> GLOOMPER_SECRET = UGJukeboxSongs.create("gloomper_secret");

    private static ResourceKey<JukeboxSong> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name));
    }

    private static void register(BootstrapContext<JukeboxSong> context, ResourceKey<JukeboxSong> key, DeferredHolder<SoundEvent, SoundEvent> soundEvent, int lengthInSeconds, int comparatorOutput) {
        context.register(key, (Object)new JukeboxSong(soundEvent, (Component)Component.translatable((String)Util.makeDescriptionId((String)"jukebox_song", (ResourceLocation)key.location())), (float)lengthInSeconds, comparatorOutput));
    }

    public static void bootstrap(BootstrapContext<JukeboxSong> context) {
        UGJukeboxSongs.register(context, MAMMOTH, UGSoundEvents.MAMMOTH_DISC, 193, 0);
        UGJukeboxSongs.register(context, LIMAX_MAXIMUS, UGSoundEvents.LIMAX_MAXIMUS_DISC, 161, 1);
        UGJukeboxSongs.register(context, RELICT, UGSoundEvents.RELICT_DISC, 187, 2);
        UGJukeboxSongs.register(context, GLOOMPER_ANTHEM, UGSoundEvents.GLOOMPER_ANTHEM_DISC, 204, 3);
        UGJukeboxSongs.register(context, GLOOMPER_SECRET, UGSoundEvents.GLOOMPER_SECRET_DISC, 159, 15);
    }
}

