/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;
import quek.undergarden.registry.UGTags;

public class UGEnchantments {
    public static final ResourceKey<Enchantment> RICOCHET = UGEnchantments.create("ricochet");
    public static final ResourceKey<Enchantment> LONGEVITY = UGEnchantments.create("longevity");
    public static final ResourceKey<Enchantment> SELF_SLING = UGEnchantments.create("self_sling");

    private static ResourceKey<Enchantment> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        context.register(RICOCHET, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(UGTags.Items.SLINGSHOT_ENCHANTABLE), (int)10, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(UGTags.Enchantments.SLINGSHOT_EXCLUSIVE)).build(RICOCHET.location()));
        context.register(LONGEVITY, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(UGTags.Items.SLINGSHOT_ENCHANTABLE), (int)10, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).build(LONGEVITY.location()));
        context.register(SELF_SLING, (Object)Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)items.getOrThrow(UGTags.Items.SLINGSHOT_ENCHANTABLE), (int)5, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantments.getOrThrow(UGTags.Enchantments.SLINGSHOT_EXCLUSIVE)).build(SELF_SLING.location()));
    }
}

