/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.armor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import quek.undergarden.registry.UGItems;

public class UndergardenArmorItem
extends ArmorItem {
    public UndergardenArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is((Item)UGItems.FROSTSTEEL_BOOTS.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.is((Item)UGItems.CLOGGRUM_BOOTS.get())) {
            tooltip.add((Component)Component.translatable((String)"tooltip.undergarden.cloggrum_boots").withStyle(ChatFormatting.GRAY));
        }
    }

    public static ItemAttributeModifiers createFroststeelAttributes(ArmorItem.Type type, int armor) {
        ResourceLocation armorLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        return ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(armorLocation, (double)armor, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(armorLocation, 4.0, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(armorLocation, (double)0.05f, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.MOVEMENT_SPEED, new AttributeModifier(armorLocation, (double)-0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), group).build();
    }
}

