/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.event;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionTransitionScreenEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerHeartTypeEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.block.portal.UndergardenPortalVisuals;
import quek.undergarden.client.gui.screen.UndergardenReceivingLevelScreen;
import quek.undergarden.client.model.BruteModel;
import quek.undergarden.client.model.DwellerModel;
import quek.undergarden.client.model.ForgottenGuardianModel;
import quek.undergarden.client.model.ForgottenModel;
import quek.undergarden.client.model.GloomperModel;
import quek.undergarden.client.model.GwibModel;
import quek.undergarden.client.model.GwiblingModel;
import quek.undergarden.client.model.MinionModel;
import quek.undergarden.client.model.MogModel;
import quek.undergarden.client.model.MuncherModel;
import quek.undergarden.client.model.NargoyleModel;
import quek.undergarden.client.model.RotbeastModel;
import quek.undergarden.client.model.RotlingModel;
import quek.undergarden.client.model.RotwalkerModel;
import quek.undergarden.client.model.ScintlingModel;
import quek.undergarden.client.model.SmogMogModel;
import quek.undergarden.client.model.SploogieModel;
import quek.undergarden.client.model.StonebornModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.particle.GrongleSporeParticle;
import quek.undergarden.client.particle.ShardParticle;
import quek.undergarden.client.particle.ShimmerParticle;
import quek.undergarden.client.particle.SmogParticle;
import quek.undergarden.client.particle.SnowflakeParticle;
import quek.undergarden.client.particle.UGDripParticles;
import quek.undergarden.client.particle.UndergardenPortalParticle;
import quek.undergarden.client.particle.UtheriumCritParticle;
import quek.undergarden.client.render.blockentity.DepthrockBedRender;
import quek.undergarden.client.render.blockentity.GrongletRender;
import quek.undergarden.client.render.blockentity.UndergardenBEWLR;
import quek.undergarden.client.render.entity.BoomgourdRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.ForgottenGuardianRender;
import quek.undergarden.client.render.entity.ForgottenRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GrongletEntityRender;
import quek.undergarden.client.render.entity.GwibRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MinionRender;
import quek.undergarden.client.render.entity.MogRender;
import quek.undergarden.client.render.entity.MuncherRender;
import quek.undergarden.client.render.entity.NargoyleRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.SmogMogRender;
import quek.undergarden.client.render.entity.SploogieRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.entity.animal.dweller.Dweller;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGWoodStuff;

public class UndergardenClientEvents {
    private static final ResourceLocation BRITTLENESS_ARMOR_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"brittleness_armor/empty");
    private static final ResourceLocation BRITTLENESS_ARMOR_HALF = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"brittleness_armor/half");
    private static final ResourceLocation BRITTLENESS_ARMOR_FULL = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"brittleness_armor/full");

    public static void initClientEvents(IEventBus bus) {
        bus.addListener(UndergardenClientEvents::clientSetup);
        bus.addListener(UndergardenClientEvents::registerEntityRenderers);
        bus.addListener(UndergardenClientEvents::registerEntityLayerDefinitions);
        bus.addListener(UndergardenClientEvents::registerParticleFactories);
        bus.addListener(UndergardenClientEvents::registerBlockColors);
        bus.addListener(UndergardenClientEvents::registerItemColors);
        bus.addListener(UndergardenClientEvents::registerOverlays);
        bus.addListener(UndergardenClientEvents::registerDimensionSpecialEffects);
        bus.addListener(UndergardenClientEvents::registerClientExtensions);
        bus.addListener(UndergardenClientEvents::registerDimensionTransitionScreens);
        NeoForge.EVENT_BUS.addListener(UndergardenClientEvents::undergardenFog);
        NeoForge.EVENT_BUS.addListener(UndergardenClientEvents::dontRenderJumpBarForDweller);
        NeoForge.EVENT_BUS.addListener(UndergardenClientEvents::undergardenPortalFOV);
        NeoForge.EVENT_BUS.addListener(UndergardenClientEvents::renderVirulentHearts);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)UGWoodStuff.SMOGSTEM_WOOD_TYPE);
            Sheets.addWoodType((WoodType)UGWoodStuff.WIGGLEWOOD_WOOD_TYPE);
            Sheets.addWoodType((WoodType)UGWoodStuff.GRONGLE_WOOD_TYPE);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"pull"), (stack, level, entity, seed) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"rotten_blisterberry"), (stack, level, entity, seed) -> entity != null && entity.getProjectile(stack).is((Item)UGItems.ROTTEN_BLISTERBERRY.get()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"goo_ball"), (stack, level, entity, seed) -> entity != null && entity.getProjectile(stack).is((Item)UGItems.GOO_BALL.get()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"gronglet"), (stack, level, entity, seed) -> entity != null && entity.getProjectile(stack).is(((Block)UGBlocks.GRONGLET.get()).asItem()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"self_sling"), (stack, level, entity, seed) -> entity != null && stack.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(UGEnchantments.SELF_SLING)) > 0 ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.CLOGGRUM_SHIELD.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"blocking"), (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        });
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get(), DepthrockBedRender::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.GRONGLET.get(), GrongletRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOOMGOURD.get(), BoomgourdRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GOO_BALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTTEN_BLISTERBERRY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BLISTERBOMB.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GRONGLET.get(), GrongletEntityRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION.get(), MinionRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTLING.get(), RotlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTWALKER.get(), RotwalkerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTBEAST.get(), RotbeastRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DWELLER.get(), DwellerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIBLING.get(), GwiblingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BRUTE.get(), BruteRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SCINTLING.get(), ScintlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GLOOMPER.get(), GloomperRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.STONEBORN.get(), StonebornRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.NARGOYLE.get(), NargoyleRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MUNCHER.get(), MuncherRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SPLOOGIE.get(), SploogieRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIB.get(), GwibRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MOG.get(), MogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SMOG_MOG.get(), SmogMogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN.get(), ForgottenRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), ForgottenGuardianRender::new);
    }

    private static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_HEAD, DepthrockBedRender::createHeadLayer);
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_FOOT, DepthrockBedRender::createFootLayer);
        event.registerLayerDefinition(UGModelLayers.GRONGLET, GrongletRender::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MINION, MinionModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTLING, RotlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTWALKER, RotwalkerModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTBEAST, RotbeastModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.DWELLER, () -> DwellerModel.createBodyLayer(0.0f));
        event.registerLayerDefinition(UGModelLayers.DWELLER_SADDLE, () -> DwellerModel.createBodyLayer(0.5f));
        event.registerLayerDefinition(UGModelLayers.GWIBLING, GwiblingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.BRUTE, BruteModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SCINTLING, ScintlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GLOOMPER, GloomperModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.STONEBORN, StonebornModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.NARGOYLE, NargoyleModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MUNCHER, MuncherModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SPLOOGIE, SploogieModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GWIB, GwibModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MOG, MogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SMOG_MOG, SmogMogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN, ForgottenModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_INNER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.1f), (float)0.0f), (int)64, (int)32));
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_OUTER_ARMOR, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.2f), (float)0.0f), (int)64, (int)32));
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_GUARDIAN, ForgottenGuardianModel::createBodyLayer);
    }

    private static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)UGParticleTypes.SHARD.get(), ShardParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.SHARD_BEAM.get(), ShardParticle.BeamProvider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.GRONGLE_SPORE.get(), GrongleSporeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.UNDERGARDEN_PORTAL.get(), UndergardenPortalParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.GLOOMPER_FART.get(), SmokeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.SHIMMER.get(), ShimmerParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.SMOG.get(), SmogParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.UTHERIUM_CRIT.get(), UtheriumCritParticle.Provider::new);
        event.registerSpriteSet((ParticleType)UGParticleTypes.SNOWFLAKE.get(), SnowflakeParticle.Provider::new);
        event.registerSprite((ParticleType)UGParticleTypes.DRIPPING_BLOOD.get(), UGDripParticles::createBloodHangParticle);
        event.registerSprite((ParticleType)UGParticleTypes.FALLING_BLOOD.get(), UGDripParticles::createBloodFallParticle);
        event.registerSprite((ParticleType)UGParticleTypes.LANDING_BLOOD.get(), UGDripParticles::createBloodLandParticle);
        event.registerSprite((ParticleType)UGParticleTypes.DRIPPING_INK.get(), UGDripParticles::createInkHangParticle);
        event.registerSprite((ParticleType)UGParticleTypes.FALLING_INK.get(), UGDripParticles::createInkFallParticle);
        event.registerSprite((ParticleType)UGParticleTypes.LANDING_INK.get(), UGDripParticles::createInkLandParticle);
        event.registerSprite((ParticleType)UGParticleTypes.FALLING_GOO.get(), UGDripParticles::createGooFallParticle);
        event.registerSprite((ParticleType)UGParticleTypes.LANDING_GOO.get(), UGDripParticles::createGooLandParticle);
        event.registerSprite((ParticleType)UGParticleTypes.DRIPPING_VIRULENT.get(), UGDripParticles::createDripstoneVirulentHangParticle);
        event.registerSprite((ParticleType)UGParticleTypes.FALLING_VIRULENT.get(), UGDripParticles::createDripstoneVirulentFallParticle);
        event.registerSprite((ParticleType)UGParticleTypes.LANDING_VIRULENT.get(), UGDripParticles::createVirulentLandParticle);
    }

    private static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tintGetter, pos, tint) -> tintGetter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)tintGetter, (BlockPos)pos) : FastColor.ARGB32.color((int)255, (int)91, (int)117, (int)91), new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPTURF.get(), (Block)UGBlocks.SHIMMERWEED.get(), (Block)UGBlocks.TALL_DEEPTURF.get(), (Block)UGBlocks.TALL_SHIMMERWEED.get(), (Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), (Block)UGBlocks.POTTED_SHIMMERWEED.get(), (Block)UGBlocks.DROOPVINE.get(), (Block)UGBlocks.DROOPVINE_PLANT.get()});
        event.register((state, world, pos, tint) -> FastColor.ARGB32.color((int)255, (int)54, (int)45, (int)66), new Block[]{(Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get()});
    }

    private static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors bColors = event.getBlockColors();
        event.register((stack, tint) -> bColors.getColor(((BlockItem)stack.getItem()).getBlock().defaultBlockState(), null, null, 0), new ItemLike[]{(ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (ItemLike)UGBlocks.DEEPTURF.get(), (ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_DEEPTURF.get()});
        event.register((stack, tint) -> {
            if (tint == 0) {
                return FastColor.ARGB32.color((int)255, (int)91, (int)117, (int)91);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get()});
    }

    private static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(UGDimensions.UNDERGARDEN_LEVEL.location(), new DimensionSpecialEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true){

            public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
                return fogColor;
            }

            public boolean isFoggyAt(int x, int y) {
                return false;
            }
        });
    }

    private static void renderVirulentHearts(PlayerHeartTypeEvent event) {
        if (event.getEntity().hasEffect(UGEffects.VIRULENCE)) {
            event.setType(Gui.HeartType.valueOf((String)"UNDERGARDEN_VIRULENT"));
        }
    }

    private static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.ARMOR_LEVEL, ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"brittleness_armor"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null && player.hasEffect(UGEffects.BRITTLENESS) && minecraft.gameMode.canHurtPlayer()) {
                UndergardenClientEvents.renderBrittlenessArmor(guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics, (Player)player);
            }
        });
        event.registerAbove(VanillaGuiLayers.EXPERIENCE_BAR, ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"dweller_xp_bar"), (guiGraphics, deltaTracker) -> {
            Dweller dweller;
            Entity patt0$temp;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null && (patt0$temp = player.getVehicle()) instanceof Dweller && (dweller = (Dweller)patt0$temp).canJump() && minecraft.gameMode.hasExperience()) {
                minecraft.gui.renderExperienceBar(guiGraphics, guiGraphics.guiWidth() / 2 - 91);
            }
        });
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"undergarden_portal_overlay"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                UndergardenClientEvents.renderPortalOverlay(guiGraphics, minecraft, window, deltaTracker.getGameTimeDeltaPartialTick(true));
            }
        });
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"carved_gloomgourd_overlay"), (guiGraphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/gloomgourd_overlay.png");
            LocalPlayer player = minecraft.player;
            if (player != null && player.getInventory().getArmor(3).is(UGBlocks.CARVED_GLOOMGOURD.asItem())) {
                minecraft.gui.renderTextureOverlay(guiGraphics, overlay, 1.0f);
            }
        });
    }

    private static void undergardenFog(ViewportEvent.RenderFog event) {
        LocalPlayer player;
        if (((Boolean)UndergardenConfig.Client.toggle_undergarden_fog.get()).booleanValue() && (player = Minecraft.getInstance().player) != null && player.level().dimension() == UGDimensions.UNDERGARDEN_LEVEL && event.getCamera().getFluidInCamera() == FogType.NONE && event.getType() == FogType.NONE && !player.isEyeInFluidType((FluidType)UGFluids.VIRULENT_MIX_TYPE.get())) {
            event.setNearPlaneDistance(-30.0f);
            event.setFarPlaneDistance(225.0f);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    private static void dontRenderJumpBarForDweller(RenderGuiLayerEvent.Pre event) {
        if (event.getName() == VanillaGuiLayers.JUMP_METER && Minecraft.getInstance().player.getVehicle() instanceof Dweller) {
            event.setCanceled(true);
        }
    }

    private static void undergardenPortalFOV(ComputeFovModifierEvent event) {
        if (UndergardenPortalVisuals.getPortalAnimTime() > 0.0f) {
            event.setNewFovModifier(event.getFovModifier() - UndergardenPortalVisuals.getPortalAnimTime());
        }
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new UndergardenBEWLR();
            }
        }, new Item[]{UGBlocks.DEPTHROCK_BED.asItem(), UGBlocks.GRONGLET.asItem()});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"fluid/virulent_mix_still");
            }

            public ResourceLocation getFlowingTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"fluid/virulent_mix_flow");
            }

            public ResourceLocation getOverlayTexture() {
                return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"fluid/virulent_mix_flow");
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTicks, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.22352941f, 0.09803922f, 0.3137255f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTicks, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)3.0f);
            }
        }, new FluidType[]{(FluidType)UGFluids.VIRULENT_MIX_TYPE.get()});
    }

    private static void registerDimensionTransitionScreens(RegisterDimensionTransitionScreenEvent event) {
        event.registerIncomingEffect(UGDimensions.UNDERGARDEN_LEVEL, UndergardenReceivingLevelScreen::new);
        event.registerOutgoingEffect(UGDimensions.UNDERGARDEN_LEVEL, UndergardenReceivingLevelScreen::new);
    }

    private static void renderBrittlenessArmor(int width, int height, GuiGraphics graphics, Player player) {
        int x = width / 2 - 91;
        int y = height - 49;
        int level = player.getArmorValue();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                graphics.blitSprite(BRITTLENESS_ARMOR_FULL, x, y, 9, 9);
            } else if (i == level) {
                graphics.blitSprite(BRITTLENESS_ARMOR_HALF, x, y, 9, 9);
            } else {
                graphics.blitSprite(BRITTLENESS_ARMOR_EMPTY, x, y, 9, 9);
            }
            x += 8;
        }
    }

    private static void renderPortalOverlay(GuiGraphics graphics, Minecraft minecraft, Window window, float partialTicks) {
        float alpha = Mth.lerp((float)partialTicks, (float)UndergardenPortalVisuals.getPrevPortalAnimTime(), (float)UndergardenPortalVisuals.getPortalAnimTime());
        if (alpha > 0.0f) {
            if (alpha < 1.0f) {
                alpha *= alpha;
                alpha *= alpha;
                alpha = alpha * 0.8f + 0.2f;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).defaultBlockState());
            graphics.blit(0, 0, -90, window.getGuiScaledWidth(), window.getGuiScaledHeight(), textureatlassprite);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

