/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile.slingshot;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import quek.undergarden.entity.animal.Scintling;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class GooBall
extends SlingshotProjectile {
    public GooBall(EntityType<? extends GooBall> type, Level level) {
        super(type, level);
        this.setDropItem(true);
    }

    public GooBall(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)UGEntityTypes.GOO_BALL.get()), shooter, level);
    }

    public GooBall(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)UGEntityTypes.GOO_BALL.get()), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)UGItems.GOO_BALL.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(this.makeParticle(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Scintling) {
                livingEntity.heal(2.0f);
            } else {
                livingEntity.hurt(this.damageSources().source(UGDamageSources.DEPTHROCK_PEBBLE, (Entity)this, this.getOwner()), 0.0f);
                livingEntity.addEffect(new MobEffectInstance(UGEffects.GOOEY, 100, 0, false, true));
            }
        }
        this.playSound(SoundEvents.SLIME_BLOCK_BREAK, 1.0f, 1.0f);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

