/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile.slingshot;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class DepthrockPebble
extends SlingshotProjectile {
    private int airTime = 1;

    public DepthrockPebble(EntityType<? extends DepthrockPebble> type, Level level) {
        super(type, level);
    }

    public DepthrockPebble(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get()), x, y, z, level);
    }

    public DepthrockPebble(Level level, LivingEntity shooter) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get()), shooter, level);
        this.setDropItem(true);
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 5L == 0L) {
            ++this.airTime;
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity victim = result.getEntity();
        float length = (float)this.getDeltaMovement().length();
        int damage = Mth.ceil((double)Mth.clamp((double)((double)length * (double)this.airTime), (double)0.0, (double)2.147483647E9));
        victim.hurt(this.damageSources().source(UGDamageSources.DEPTHROCK_PEBBLE, (Entity)this, this.getOwner()), (float)damage);
        this.playSound(SoundEvents.STONE_BREAK, 1.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected Item getDefaultItem() {
        return (Item)UGItems.DEPTHROCK_PEBBLE.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(this.makeParticle(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

