/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.advancements.packs.VanillaAdventureAdvancements;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import quek.undergarden.criterion.SlingshotFireTrigger;
import quek.undergarden.criterion.StonebornTradeTrigger;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGStructures;

public class UndergardenAdvancements
implements AdvancementProvider.AdvancementGenerator {
    private static final List<ResourceKey<Biome>> UNDERGARDEN_BIOMES = ImmutableList.of(UGBiomes.ANCIENT_SEA, UGBiomes.BARREN_ABYSS, UGBiomes.DEAD_SEA, UGBiomes.DENSE_FOREST, UGBiomes.FORGOTTEN_FIELD, UGBiomes.FROSTFIELDS, UGBiomes.FROSTY_SMOGSTEM_FOREST, UGBiomes.GRONGLEGROWTH, UGBiomes.ICY_SEA, UGBiomes.BLOOD_MUSHROOM_BOG, UGBiomes.SMOG_SPIRES, UGBiomes.SMOGSTEM_FOREST, (Object[])new ResourceKey[]{UGBiomes.WIGGLEWOOD_FOREST, UGBiomes.INDIGO_MUSHROOM_BOG, UGBiomes.INK_MUSHROOM_BOG, UGBiomes.VEIL_MUSHROOM_BOG});

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (Component)Component.translatable((String)"advancement.undergarden.root.title"), (Component)Component.empty(), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/block/depthrock_bricks.png"), AdvancementType.TASK, false, false, false).addCriterion("tick", PlayerTrigger.TriggerInstance.tick()).save(consumer, "undergarden:undergarden/root");
        AdvancementHolder catalyst = Advancement.Builder.advancement().parent(root).display((ItemLike)UGItems.CATALYST.get(), (Component)Component.translatable((String)"advancement.undergarden.catalyst.title"), (Component)Component.translatable((String)"advancement.undergarden.catalyst.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_catalyst", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CATALYST.get()})).save(consumer, "undergarden:undergarden/catalyst");
        AdvancementHolder enter_undergarden = Advancement.Builder.advancement().parent(catalyst).display((ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (Component)Component.translatable((String)"advancement.undergarden.enter_undergarden.title"), (Component)Component.translatable((String)"advancement.undergarden.enter_undergarden.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("enter_undergarden", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(UGDimensions.UNDERGARDEN_LEVEL)).save(consumer, "undergarden:undergarden/enter_undergarden");
        AdvancementHolder slingshot = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.SLINGSHOT.get(), (Component)Component.translatable((String)"advancement.undergarden.slingshot.title"), (Component)Component.translatable((String)"advancement.undergarden.slingshot.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_slingshot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.SLINGSHOT.get()})).save(consumer, "undergarden:undergarden/slingshot");
        AdvancementHolder shoot_slingshot = Advancement.Builder.advancement().parent(slingshot).display((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot.title"), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("shoot_slingshot", SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).save(consumer, "undergarden:undergarden/shoot_slingshot");
        AdvancementHolder shoot_slingshot_goo = Advancement.Builder.advancement().parent(slingshot).display((ItemLike)UGItems.GOO_BALL.get(), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_goo.title"), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_goo.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("shoot_slingshot_goo", SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.GOO_BALL.get())).save(consumer, "undergarden:undergarden/shoot_slingshot_goo");
        AdvancementHolder shoot_slingshot_rotten_blisterberry = Advancement.Builder.advancement().parent(slingshot).display((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_rotten_blisterberry.title"), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_rotten_blisterberry.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("shoot_slingshot_rotten_blisterberry", SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get())).save(consumer, "undergarden:undergarden/shoot_slingshot_rotten_blisterberry");
        AdvancementHolder slingshot_20_damage = Advancement.Builder.advancement().parent(shoot_slingshot).display((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), (Component)Component.translatable((String)"advancement.undergarden.slingshot_20_damage.title"), (Component)Component.translatable((String)"advancement.undergarden.slingshot_20_damage.desc"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("20_damage", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity((DamagePredicate.Builder)DamagePredicate.Builder.damageInstance().dealtDamage(MinMaxBounds.Doubles.atLeast((double)20.0)).type(DamageSourcePredicate.Builder.damageType().direct(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get()))), Optional.empty())).save(consumer, "undergarden:undergarden/slingshot_20_damage");
        AdvancementHolder shoot_slingshot_gronglet = Advancement.Builder.advancement().parent(slingshot).display((ItemLike)UGBlocks.GRONGLET.get(), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_gronglet.title"), (Component)Component.translatable((String)"advancement.undergarden.shoot_slingshot_gronglet.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("shoot_slingshot_gronglet", SlingshotFireTrigger.TriggerInstance.shotItem((ItemLike)UGBlocks.GRONGLET.get())).save(consumer, "undergarden:undergarden/shoot_slingshot_gronglet");
        AdvancementHolder underbeans = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.UNDERBEANS.get(), (Component)Component.translatable((String)"advancement.undergarden.underbeans.title"), (Component)Component.translatable((String)"advancement.undergarden.underbeans.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_underbeans", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UNDERBEANS.get()})).save(consumer, "undergarden:undergarden/underbeans");
        AdvancementHolder stoneborn_trade = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.REGALIUM_CRYSTAL.get(), (Component)Component.translatable((String)"advancement.undergarden.stoneborn_trade.title"), (Component)Component.translatable((String)"advancement.undergarden.stoneborn_trade.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("trade_with_stoneborn", StonebornTradeTrigger.TriggerInstance.tradeWithStoneborn()).save(consumer, "undergarden:undergarden/stoneborn_trade");
        AdvancementHolder mine_ore = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.RAW_CLOGGRUM.get(), (Component)Component.translatable((String)"advancement.undergarden.mine_ore.title"), (Component)Component.translatable((String)"advancement.undergarden.mine_ore.desc"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("has_raw_cloggrum", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.RAW_CLOGGRUM.get()})).addCriterion("has_raw_froststeel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.RAW_FROSTSTEEL.get()})).addCriterion("has_utherium", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UTHERIUM_CRYSTAL.get()})).addCriterion("has_regalium_crystal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.REGALIUM_CRYSTAL.get()})).addCriterion("has_depthrock_cloggrum", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_CLOGGRUM_ORE.get()})).addCriterion("has_shiverstone_cloggrum", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE.get()})).addCriterion("has_shiverstone_froststeel", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE.get()})).addCriterion("has_depthrock_utherium", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_UTHERIUM_ORE.get()})).addCriterion("has_shiverstone_utherium", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_UTHERIUM_ORE.get()})).addCriterion("has_depthrock_regalium", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.DEPTHROCK_REGALIUM_ORE.get()})).addCriterion("has_shiverstone_regalium", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHIVERSTONE_REGALIUM_ORE.get()})).save(consumer, "undergarden:undergarden/mine_ore");
        AdvancementHolder all_ore_blocks = Advancement.Builder.advancement().parent(mine_ore).display((ItemLike)UGBlocks.REGALIUM_BLOCK.get(), (Component)Component.translatable((String)"advancement.undergarden.all_ore_blocks.title"), (Component)Component.translatable((String)"advancement.undergarden.all_ore_blocks.desc"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("has_all_ore_blocks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.CLOGGRUM_BLOCK.get(), (ItemLike)UGBlocks.FROSTSTEEL_BLOCK.get(), (ItemLike)UGBlocks.UTHERIUM_BLOCK.get(), (ItemLike)UGBlocks.REGALIUM_BLOCK.get()})).save(consumer, "undergarden:undergarden/all_ore_blocks");
        AdvancementHolder cloggrum_armor = Advancement.Builder.advancement().parent(mine_ore).display((ItemLike)UGItems.CLOGGRUM_CHESTPLATE.get(), (Component)Component.translatable((String)"advancement.undergarden.cloggrum_armor.title"), (Component)Component.translatable((String)"advancement.undergarden.cloggrum_armor.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("has_cloggrum_armor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CLOGGRUM_HELMET.get(), (ItemLike)UGItems.CLOGGRUM_CHESTPLATE.get(), (ItemLike)UGItems.CLOGGRUM_LEGGINGS.get(), (ItemLike)UGItems.CLOGGRUM_BOOTS.get()})).save(consumer, "undergarden:undergarden/cloggrum_armor");
        VanillaAdventureAdvancements.addBiomes((Advancement.Builder)Advancement.Builder.advancement(), (HolderLookup.Provider)provider, UNDERGARDEN_BIOMES).parent(enter_undergarden).display((ItemLike)UGItems.CLOGGRUM_BOOTS.get(), (Component)Component.translatable((String)"advancement.undergarden.all_undergarden_biomes.title"), (Component)Component.translatable((String)"advancement.undergarden.all_undergarden_biomes.desc"), null, AdvancementType.CHALLENGE, true, true, false).save(consumer, "undergarden:undergarden/all_undergarden_biomes");
        AdvancementHolder plant_gloomgourd = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.GLOOMGOURD_SEEDS.get(), (Component)Component.translatable((String)"advancement.undergarden.plant_gloomgourd.title"), (Component)Component.translatable((String)"advancement.undergarden.plant_gloomgourd.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("plant_gloomgourd", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)((Block)UGBlocks.GLOOMGOURD_STEM.get()))).save(consumer, "undergarden:undergarden/plant_gloomgourd");
        AdvancementHolder stack_of_gloomgourds = Advancement.Builder.advancement().parent(plant_gloomgourd).display((ItemLike)UGBlocks.GLOOMGOURD.get(), (Component)Component.translatable((String)"advancement.undergarden.stack_of_gloomgourds.title"), (Component)Component.translatable((String)"advancement.undergarden.stack_of_gloomgourds.desc"), null, AdvancementType.GOAL, true, true, true).addCriterion("has_64_gloomgourds", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}).withCount(MinMaxBounds.Ints.exactly((int)64)).build()})).save(consumer, "undergarden:undergarden/stack_of_gloomgourds");
        AdvancementHolder catch_gwibling = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.GWIBLING_BUCKET.get(), (Component)Component.translatable((String)"advancement.undergarden.catch_gwibling.title"), (Component)Component.translatable((String)"advancement.undergarden.catch_gwibling.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_gwibling_bucket", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.GWIBLING_BUCKET.get()})).save(consumer, "undergarden:undergarden/catch_gwibling");
        AdvancementHolder kill_rotling = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.UTHERIC_SHARD.get(), (Component)Component.translatable((String)"advancement.undergarden.kill_rotling.title"), (Component)Component.translatable((String)"advancement.undergarden.kill_rotling.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("kill_rotling", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.ROTLING.get()).build()))).save(consumer, "undergarden:undergarden/kill_rotling");
        AdvancementHolder shard_torch = Advancement.Builder.advancement().parent(kill_rotling).display((ItemLike)UGBlocks.SHARD_TORCH.get(), (Component)Component.translatable((String)"advancement.undergarden.shard_torch.title"), (Component)Component.translatable((String)"advancement.undergarden.shard_torch.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_shard_torch", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.SHARD_TORCH.get()})).save(consumer, "undergarden:undergarden/shard_torch");
        AdvancementHolder kill_all_rotspawn = Advancement.Builder.advancement().parent(kill_rotling).display((ItemLike)UGItems.UTHERIUM_SWORD.get(), (Component)Component.translatable((String)"advancement.undergarden.kill_all_rotspawn.title"), (Component)Component.translatable((String)"advancement.undergarden.kill_all_rotspawn.desc"), null, AdvancementType.CHALLENGE, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("kill_rotling", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.ROTLING.get()).build()))).addCriterion("kill_rotwalker", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.ROTWALKER.get()).build()))).addCriterion("kill_rotbeast", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.ROTBEAST.get()).build()))).save(consumer, "undergarden:undergarden/kill_all_rotspawn");
        AdvancementHolder kill_scintling = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.GOO_BALL.get(), (Component)Component.translatable((String)"advancement.undergarden.kill_scintling.title"), (Component)Component.translatable((String)"advancement.undergarden.kill_scintling.desc"), null, AdvancementType.TASK, true, true, true).addCriterion("kill_scintling", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.SCINTLING.get()).build()))).save(consumer, "undergarden:undergarden/kill_scintling");
        AdvancementHolder catacombs = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGBlocks.DEPTHROCK_BRICK_STAIRS.get(), (Component)Component.translatable((String)"advancement.undergarden.catacombs.title"), (Component)Component.translatable((String)"advancement.undergarden.catacombs.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("enter_catacombs", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)provider.lookupOrThrow(Registries.STRUCTURE).getOrThrow(UGStructures.CATACOMBS)))).save(consumer, "undergarden:undergarden/catacombs");
        AdvancementHolder cloggrum_battleaxe = Advancement.Builder.advancement().parent(catacombs).display((ItemLike)UGItems.CLOGGRUM_BATTLEAXE.get(), (Component)Component.translatable((String)"advancement.undergarden.cloggrum_battleaxe.title"), (Component)Component.translatable((String)"advancement.undergarden.cloggrum_battleaxe.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("has_cloggrum_battleaxe", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CLOGGRUM_BATTLEAXE.get()})).save(consumer, "undergarden:undergarden/cloggrum_battleaxe");
        AdvancementHolder kill_guardian = Advancement.Builder.advancement().parent(catacombs).display((ItemLike)UGBlocks.FORGOTTEN_BLOCK.get(), (Component)Component.translatable((String)"advancement.undergarden.kill_forgotten_guardian.title"), (Component)Component.translatable((String)"advancement.undergarden.kill_forgotten_guardian.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("kill_forgotten_guardian", KilledTrigger.TriggerInstance.playerKilledEntity(Optional.of(EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get()).build()))).save(consumer, "undergarden:undergarden/kill_forgotten_guardian");
        AdvancementHolder forgotten_ingot = Advancement.Builder.advancement().parent(kill_guardian).display((ItemLike)UGItems.FORGOTTEN_INGOT.get(), (Component)Component.translatable((String)"advancement.undergarden.forgotten_ingot.title"), (Component)Component.translatable((String)"advancement.undergarden.forgotten_ingot.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("has_forgotten_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_INGOT.get()})).save(consumer, "undergarden:undergarden/forgotten_ingot");
        AdvancementHolder forgotten_tools = Advancement.Builder.advancement().parent(forgotten_ingot).display((ItemLike)UGItems.FORGOTTEN_PICKAXE.get(), (Component)Component.translatable((String)"advancement.undergarden.forgotten_tools.title"), (Component)Component.translatable((String)"advancement.undergarden.forgotten_tools.desc"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("has_forgotten_tools", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get(), (ItemLike)UGItems.FORGOTTEN_SWORD.get(), (ItemLike)UGItems.FORGOTTEN_PICKAXE.get(), (ItemLike)UGItems.FORGOTTEN_AXE.get(), (ItemLike)UGItems.FORGOTTEN_SHOVEL.get(), (ItemLike)UGItems.FORGOTTEN_HOE.get()})).save(consumer, "undergarden:undergarden/forgotten_tools");
        AdvancementHolder forgotten_battleaxe = Advancement.Builder.advancement().parent(cloggrum_battleaxe).display((ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get(), (Component)Component.translatable((String)"advancement.undergarden.forgotten_battleaxe.title"), (Component)Component.translatable((String)"advancement.undergarden.forgotten_battleaxe.desc"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("has_forgotten_battleaxe", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FORGOTTEN_BATTLEAXE.get()})).save(consumer, "undergarden:undergarden/forgotten_battleaxe");
        AdvancementHolder summon_minion = Advancement.Builder.advancement().parent(forgotten_ingot).display((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get(), (Component)Component.translatable((String)"advancement.undergarden.summon_minion.title"), (Component)Component.translatable((String)"advancement.undergarden.summon_minion.desc"), null, AdvancementType.GOAL, true, true, false).addCriterion("summoned_minion", SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)UGEntityTypes.MINION.get()))).save(consumer, "undergarden:undergarden/summon_minion");
        AdvancementHolder gloomper_secret_disc = Advancement.Builder.advancement().parent(enter_undergarden).display((ItemLike)UGItems.GLOOMPER_SECRET_DISC.get(), (Component)Component.translatable((String)"advancement.undergarden.gloomper_secret_disc.title"), (Component)Component.translatable((String)"advancement.undergarden.gloomper_secret_disc.desc"), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("has_disc", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UGItems.GLOOMPER_SECRET_DISC.get()})).save(consumer, "undergarden:undergarden/gloomper_secret_disc");
    }
}

