/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.neoforged.neoforge.common.Tags;
import quek.undergarden.data.provider.UGRecipeProvider;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGTags;

public class UGRecipes
extends UGRecipeProvider {
    public UGRecipes(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.makePlanks((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS, UGTags.Items.SMOGSTEM_LOGS).save(consumer);
        this.makePlanks((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS, UGTags.Items.WIGGLEWOOD_LOGS).save(consumer);
        this.makePlanks((Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS, UGTags.Items.GRONGLE_LOGS).save(consumer);
        this.makeBricks((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makeBricks((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS, (Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK).save(consumer);
        this.makeBricks((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makeBricks((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makeBricks((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS).save(consumer);
        this.makeChiseledBricks((Supplier<? extends Block>)UGBlocks.CHISELED_DEPTHROCK_BRICKS, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_SLAB).save(consumer);
        this.makeChiseledBricks((Supplier<? extends Block>)UGBlocks.CHISELED_SHIVERSTONE_BRICKS, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_SLAB).save(consumer);
        this.makeChiseledBricks((Supplier<? extends Block>)UGBlocks.CHISELED_TREMBLECRUST_BRICKS, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_SLAB).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WOOD, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_LOG).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_WOOD, (Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WOOD, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_LOG).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD, (Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.GRONGLE_WOOD, (Supplier<? extends Block>)UGBlocks.GRONGLE_LOG).save(consumer);
        this.makeWood((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_WOOD, (Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG).save(consumer);
        this.makeBoat((Supplier<? extends Item>)UGItems.SMOGSTEM_BOAT, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeBoat((Supplier<? extends Item>)UGItems.WIGGLEWOOD_BOAT, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeBoat((Supplier<? extends Item>)UGItems.GRONGLE_BOAT, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeChestBoat((Supplier<? extends Item>)UGItems.SMOGSTEM_CHEST_BOAT, (Supplier<? extends Item>)UGItems.SMOGSTEM_BOAT).save(consumer);
        this.makeChestBoat((Supplier<? extends Item>)UGItems.WIGGLEWOOD_CHEST_BOAT, (Supplier<? extends Item>)UGItems.WIGGLEWOOD_BOAT).save(consumer);
        this.makeChestBoat((Supplier<? extends Item>)UGItems.GRONGLE_CHEST_BOAT, (Supplier<? extends Item>)UGItems.GRONGLE_BOAT).save(consumer);
        this.makeSign((Supplier<? extends SignBlock>)UGBlocks.SMOGSTEM_SIGN, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeSign((Supplier<? extends SignBlock>)UGBlocks.WIGGLEWOOD_SIGN, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeSign((Supplier<? extends SignBlock>)UGBlocks.GRONGLE_SIGN, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)UGBlocks.SMOGSTEM_HANGING_SIGN, (Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG).save(consumer);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)UGBlocks.WIGGLEWOOD_HANGING_SIGN, (Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG).save(consumer);
        this.makeHangingSign((Supplier<? extends CeilingHangingSignBlock>)UGBlocks.GRONGLE_HANGING_SIGN, (Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.STICKY_PISTON).pattern("G").pattern("P").define(Character.valueOf('G'), (ItemLike)UGItems.GOO_BALL.get()).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).unlockedBy("has_goo_ball", UGRecipes.has((ItemLike)((ItemLike)UGItems.GOO_BALL.get()))).save(consumer, this.name("sticky_piston_from_goo_ball"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.STONECUTTER).pattern(" I ").pattern("SSS").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)UGBlocks.DEPTHROCK.get()).unlockedBy("has_depthrock", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.DEPTHROCK.get()))).save(consumer, this.name("stonecutter_from_depthrock"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.STONECUTTER).pattern(" I ").pattern("SSS").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)UGBlocks.SHIVERSTONE.get()).unlockedBy("has_shiverstone", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.SHIVERSTONE.get()))).save(consumer, this.name("stonecutter_from_shiverstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.STONECUTTER).pattern(" I ").pattern("SSS").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)UGBlocks.TREMBLECRUST.get()).unlockedBy("has_tremblecrust", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.TREMBLECRUST.get()))).save(consumer, this.name("stonecutter_from_tremblecrust"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.UNDERBEAN_STICK.get())).requires((ItemLike)Items.STICK).requires((ItemLike)UGItems.UNDERBEANS.get()).unlockedBy("has_underbeans", UGRecipes.has((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.MOGMOSS_RUG.get()), (int)3).pattern("MM").define(Character.valueOf('M'), (ItemLike)UGItems.MOGMOSS.get()).unlockedBy("has_mogmoss", UGRecipes.has((ItemLike)((ItemLike)UGItems.MOGMOSS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.BLUE_MOGMOSS_RUG.get()), (int)3).pattern("MM").define(Character.valueOf('M'), (ItemLike)UGItems.BLUE_MOGMOSS.get()).unlockedBy("has_blue_mogmoss", UGRecipes.has((ItemLike)((ItemLike)UGItems.BLUE_MOGMOSS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.DEPTHROCK_BED.get())).pattern("MMM").pattern("DDD").define(Character.valueOf('M'), (ItemLike)UGItems.MOGMOSS.get()).define(Character.valueOf('D'), (ItemLike)UGBlocks.DEPTHROCK.get()).unlockedBy("has_mogmoss", UGRecipes.has((ItemLike)((ItemLike)UGItems.MOGMOSS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.TWISTYTWIG.get()), (int)4).pattern("P ").pattern(" P").define(Character.valueOf('P'), (ItemLike)UGBlocks.WIGGLEWOOD_PLANKS.get()).unlockedBy("has_wigglewood_planks", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_PLANKS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.SCAFFOLDING, (int)6).pattern("STS").pattern("S S").pattern("S S").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('T'), (ItemLike)UGItems.TWISTYTWIG.get()).unlockedBy("has_stick", UGRecipes.has((TagKey)Tags.Items.RODS_WOODEN)).unlockedBy("has_twistytwig", UGRecipes.has((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get()))).save(consumer, this.name("undergarden_scaffolding"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.GLOOM_O_LANTERN.get())).pattern("G").pattern("T").define(Character.valueOf('G'), (ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_carved_gourd", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()))).unlockedBy("has_torch", UGRecipes.has((ItemLike)Items.TORCH)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.SHARD_O_LANTERN.get())).pattern("G").pattern("T").define(Character.valueOf('G'), (ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()).define(Character.valueOf('T'), (ItemLike)UGBlocks.SHARD_TORCH.get()).unlockedBy("has_carved_gourd", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()))).unlockedBy("has_shard_torch", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.SHARD_TORCH.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.CLOGGRUM_BARS.get()), (int)16).pattern("CCC").pattern("CCC").define(Character.valueOf('C'), (ItemLike)UGItems.CLOGGRUM_INGOT.get()).unlockedBy("has_cloggrum_ingot", UGRecipes.has((ItemLike)((ItemLike)UGItems.CLOGGRUM_INGOT.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)UGBlocks.COARSE_DEEPSOIL.get()), (int)4).pattern("DP").pattern("PD").define(Character.valueOf('D'), (ItemLike)UGBlocks.DEEPSOIL.get()).define(Character.valueOf('P'), (ItemLike)UGItems.DEPTHROCK_PEBBLE.get()).unlockedBy("has_deepsoil", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.DEEPSOIL.get()))).unlockedBy("has_pebble", UGRecipes.has((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)UGBlocks.DEEPSOIL.get())).requires((ItemLike)UGBlocks.COARSE_DEEPSOIL.get()).unlockedBy("has_coarse_deepsoil", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.COARSE_DEEPSOIL.get()))).save(consumer, this.name("coarse_deepsoil_to_normal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)UGItems.SLINGSHOT.get())).pattern("STS").pattern("SSS").pattern(" S ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('T'), (ItemLike)UGItems.TWISTYTWIG.get()).unlockedBy("has_stick", UGRecipes.has((TagKey)Tags.Items.RODS_WOODEN)).unlockedBy("has_twistytwig", UGRecipes.has((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.BLISTERBOMB.get())).pattern(" T ").pattern("BBB").pattern("BBB").define(Character.valueOf('T'), (ItemLike)UGItems.TWISTYTWIG.get()).define(Character.valueOf('B'), (ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()).unlockedBy("has_twistytwig", UGRecipes.has((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get()))).unlockedBy("has_blisterberry", UGRecipes.has((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)UGItems.CLOGGRUM_SHIELD.get())).pattern("CSC").pattern("CCC").pattern(" C ").define(Character.valueOf('S'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)UGItems.CLOGGRUM_INGOT.get()).unlockedBy("has_scales", UGRecipes.has((ItemLike)((ItemLike)UGItems.CLOGGRUM_INGOT.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.SHARD_TORCH.get()), (int)1).pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)UGItems.UTHERIC_SHARD.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_shard", UGRecipes.has((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get()))).unlockedBy("has_stick", UGRecipes.has((TagKey)Tags.Items.RODS_WOODEN)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.TORCH, (int)2).pattern("D").pattern("S").define(Character.valueOf('D'), (ItemLike)UGItems.DITCHBULB_PASTE.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy("has_ditchbulb_paste", UGRecipes.has((ItemLike)((ItemLike)UGItems.DITCHBULB_PASTE.get()))).unlockedBy("has_stick", UGRecipes.has((TagKey)Tags.Items.RODS_WOODEN)).save(consumer, this.name("torch_ditchbulb_paste"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)UGItems.CATALYST.get())).pattern("GIG").pattern("IDI").pattern("GIG").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).unlockedBy("has_gold", UGRecipes.has((ItemLike)Items.GOLD_INGOT)).unlockedBy("has_iron", UGRecipes.has((ItemLike)Items.IRON_INGOT)).unlockedBy("has_diamond", UGRecipes.has((ItemLike)Items.DIAMOND)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)UGItems.GLOOMGOURD_PIE.get())).requires(UGTags.Items.MUSHROOMS).requires((ItemLike)UGBlocks.GLOOMGOURD.get()).requires((ItemLike)UGItems.GLITTERKELP.get()).unlockedBy("has_gloomgourd", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.GLOOMGOURD_SEEDS.get()), (int)4).requires((ItemLike)UGBlocks.GLOOMGOURD.get()).unlockedBy("has_gloomgourd", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL, (int)4).requires((ItemLike)UGItems.BRUTE_TUSK.get()).unlockedBy("has_tusk", UGRecipes.has((ItemLike)((ItemLike)UGItems.BRUTE_TUSK.get()))).save(consumer, this.name("tusk_to_bonemeal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE).requires((ItemLike)UGBlocks.BLOOD_MUSHROOM.get()).unlockedBy("has_blood_mushroom", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM.get()))).save(consumer, this.name("blood_mushroom_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLACK_DYE).requires((ItemLike)UGBlocks.INK_MUSHROOM.get()).unlockedBy("has_ink_mushroom", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM.get()))).save(consumer, this.name("ink_mushroom_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLUE_DYE).requires((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()).unlockedBy("has_indigo_mushroom", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()))).save(consumer, this.name("indigo_mushroom_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.WHITE_DYE).requires((ItemLike)UGBlocks.VEIL_MUSHROOM.get()).unlockedBy("has_veil_mushroom", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM.get()))).save(consumer, this.name("veil_mushroom_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PINK_DYE).requires((ItemLike)UGBlocks.AMOROUS_BRISTLE.get()).unlockedBy("has_amorous_bristle", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.AMOROUS_BRISTLE.get()))).save(consumer, this.name("amorous_bristle_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LIGHT_BLUE_DYE).requires((ItemLike)UGBlocks.MISERABELL.get()).unlockedBy("has_miserabell", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.MISERABELL.get()))).save(consumer, this.name("miserabell_to_dye"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.YELLOW_DYE).requires((ItemLike)UGBlocks.BUTTERBUNCH.get()).unlockedBy("has_butterbunch", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.BUTTERBUNCH.get()))).save(consumer, this.name("butterbunch_to_dye"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.UTHERIUM_CRYSTAL.get())).pattern("SSS").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)UGItems.UTHERIC_SHARD.get()).unlockedBy("has_shard", UGRecipes.has((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get()))).save(consumer, this.name("shard_to_crystal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEAD, (int)2).pattern("TT ").pattern("TG ").pattern("  T").define(Character.valueOf('T'), (ItemLike)UGItems.TWISTYTWIG.get()).define(Character.valueOf('G'), (ItemLike)UGItems.GOO_BALL.get()).unlockedBy("has_twistytwig", UGRecipes.has((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get()))).unlockedBy("has_goo_ball", UGRecipes.has((ItemLike)((ItemLike)UGItems.GOO_BALL.get()))).save(consumer, this.name("undergarden_lead"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.SEDIMENT_GLASS_PANE.get()), (int)16).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), (ItemLike)UGBlocks.SEDIMENT_GLASS.get()).unlockedBy("has_sediment_glass", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.SEDIMENT_GLASS.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)UGBlocks.CLOGGRUM_TILES.get()), (int)4).pattern("CC").pattern("CC").define(Character.valueOf('C'), (ItemLike)UGItems.CLOGGRUM_INGOT.get()).unlockedBy("has_cloggrum_ingot", UGRecipes.has((ItemLike)((ItemLike)UGItems.CLOGGRUM_INGOT.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)UGBlocks.CLOGGRUM_LANTERN.get())).pattern("NNN").pattern("NTN").pattern("NNN").define(Character.valueOf('N'), (ItemLike)UGItems.CLOGGRUM_NUGGET.get()).define(Character.valueOf('T'), (ItemLike)Items.TORCH).unlockedBy("has_cloggrum_ingot", UGRecipes.has((ItemLike)((ItemLike)UGItems.CLOGGRUM_INGOT.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)UGBlocks.BOOMGOURD.get())).pattern("BBB").pattern("BGB").pattern("BBB").define(Character.valueOf('B'), (ItemLike)UGItems.BLISTERBOMB.get()).define(Character.valueOf('G'), (ItemLike)UGBlocks.GLOOMGOURD.get()).unlockedBy("has_gloomgourd", UGRecipes.has((ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()))).unlockedBy("has_blisterbomb", UGRecipes.has((ItemLike)((ItemLike)UGItems.BLISTERBOMB.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.DITCHBULB_PASTE.get())).requires((ItemLike)UGItems.DITCHBULB.get()).unlockedBy("has_ditchbulb", UGRecipes.has((ItemLike)((ItemLike)UGItems.DITCHBULB.get()))).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK, (Supplier<? extends Item>)UGItems.FORGOTTEN_INGOT).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.DEPTHROCK, (Supplier<? extends Item>)UGItems.DEPTHROCK_PEBBLE).save(consumer, this.name("pebbles_to_depthrock"));
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.GOO_BLOCK, (Supplier<? extends Item>)UGItems.GOO_BALL).save(consumer);
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT, (Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK).save(consumer, this.name("cloggrum_block_to_ingot"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT, (Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK).save(consumer, this.name("froststeel_block_to_ingot"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL, (Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK).save(consumer, this.name("utherium_block_to_crystal"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL, (Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK).save(consumer, this.name("regalium_block_to_crystal"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.FORGOTTEN_INGOT, (Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK).save(consumer, this.name("forgotten_block_to_ingot"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.GOO_BALL, (Supplier<? extends Block>)UGBlocks.GOO_BLOCK).save(consumer, this.name("goo_block_to_ball"));
        this.makeIngotToNugget((Supplier<? extends Item>)UGItems.CLOGGRUM_NUGGET, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer, this.name("cloggrum_ingot_to_nugget"));
        this.makeIngotToNugget((Supplier<? extends Item>)UGItems.FROSTSTEEL_NUGGET, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer, this.name("froststeel_ingot_to_nugget"));
        this.makeIngotToNugget((Supplier<? extends Item>)UGItems.FORGOTTEN_NUGGET, (Supplier<? extends Item>)UGItems.FORGOTTEN_INGOT).save(consumer, this.name("forgotten_ingot_to_nugget"));
        this.makeNuggetToIngot((Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT, (Supplier<? extends Item>)UGItems.CLOGGRUM_NUGGET).save(consumer, this.name("cloggrum_nugget_to_ingot"));
        this.makeNuggetToIngot((Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT, (Supplier<? extends Item>)UGItems.FROSTSTEEL_NUGGET).save(consumer, this.name("froststeel_nugget_to_ingot"));
        this.makeNuggetToIngot((Supplier<? extends Item>)UGItems.FORGOTTEN_INGOT, (Supplier<? extends Item>)UGItems.FORGOTTEN_NUGGET).save(consumer, this.name("forgotten_nugget_to_ingot"));
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.RAW_CLOGGRUM_BLOCK, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM).save(consumer);
        this.makeIngotToBlock((Supplier<? extends Block>)UGBlocks.RAW_FROSTSTEEL_BLOCK, (Supplier<? extends Item>)UGItems.RAW_FROSTSTEEL).save(consumer);
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.RAW_CLOGGRUM, (Supplier<? extends Block>)UGBlocks.RAW_CLOGGRUM_BLOCK).save(consumer, this.name("raw_cloggrum_from_block"));
        this.makeBlockToIngot((Supplier<? extends Item>)UGItems.RAW_FROSTSTEEL, (Supplier<? extends Block>)UGBlocks.RAW_FROSTSTEEL_BLOCK).save(consumer, this.name("raw_froststeel_from_block"));
        this.makeSword((Supplier<? extends Item>)UGItems.CLOGGRUM_SWORD, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeSword((Supplier<? extends Item>)UGItems.FROSTSTEEL_SWORD, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeSword((Supplier<? extends Item>)UGItems.UTHERIUM_SWORD, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makePickaxe((Supplier<? extends Item>)UGItems.CLOGGRUM_PICKAXE, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makePickaxe((Supplier<? extends Item>)UGItems.FROSTSTEEL_PICKAXE, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makePickaxe((Supplier<? extends Item>)UGItems.UTHERIUM_PICKAXE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeAxe((Supplier<? extends Item>)UGItems.CLOGGRUM_AXE, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeAxe((Supplier<? extends Item>)UGItems.FROSTSTEEL_AXE, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeAxe((Supplier<? extends Item>)UGItems.UTHERIUM_AXE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeShovel((Supplier<? extends Item>)UGItems.CLOGGRUM_SHOVEL, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeShovel((Supplier<? extends Item>)UGItems.FROSTSTEEL_SHOVEL, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeShovel((Supplier<? extends Item>)UGItems.UTHERIUM_SHOVEL, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeHoe((Supplier<? extends Item>)UGItems.CLOGGRUM_HOE, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeHoe((Supplier<? extends Item>)UGItems.FROSTSTEEL_HOE, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeHoe((Supplier<? extends Item>)UGItems.UTHERIUM_HOE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeHelmet((Supplier<? extends Item>)UGItems.CLOGGRUM_HELMET, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeChestplate((Supplier<? extends Item>)UGItems.CLOGGRUM_CHESTPLATE, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeLeggings((Supplier<? extends Item>)UGItems.CLOGGRUM_LEGGINGS, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeBoots((Supplier<? extends Item>)UGItems.CLOGGRUM_BOOTS, (Supplier<? extends Item>)UGItems.CLOGGRUM_INGOT).save(consumer);
        this.makeHelmet((Supplier<? extends Item>)UGItems.FROSTSTEEL_HELMET, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeChestplate((Supplier<? extends Item>)UGItems.FROSTSTEEL_CHESTPLATE, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeLeggings((Supplier<? extends Item>)UGItems.FROSTSTEEL_LEGGINGS, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeBoots((Supplier<? extends Item>)UGItems.FROSTSTEEL_BOOTS, (Supplier<? extends Item>)UGItems.FROSTSTEEL_INGOT).save(consumer);
        this.makeHelmet((Supplier<? extends Item>)UGItems.UTHERIUM_HELMET, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeChestplate((Supplier<? extends Item>)UGItems.UTHERIUM_CHESTPLATE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeLeggings((Supplier<? extends Item>)UGItems.UTHERIUM_LEGGINGS, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeBoots((Supplier<? extends Item>)UGItems.UTHERIUM_BOOTS, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.DEPTHROCK_STAIRS, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_STAIRS, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.SMOGSTEM_STAIRS, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_STAIRS, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.GRONGLE_STAIRS, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_STAIRS, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_STAIRS, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_STAIRS, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_STAIRS, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_STAIRS, (Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILES).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_STAIRS, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES).save(consumer);
        this.makeStairs((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_STAIRS, (Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.DEPTHROCK_SLAB, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_SLAB, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SLAB, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SLAB, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.GRONGLE_SLAB, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_SLAB, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_SLAB, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_SLAB, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_SLAB, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_SLAB, (Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILES).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_SLAB, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES).save(consumer);
        this.makeSlab((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_SLAB, (Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.DEPTHROCK_WALL, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_WALL, (Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_WALL, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_WALL, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_WALL, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_WALL, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS).save(consumer);
        this.makeWall((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_WALL, (Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK).save(consumer);
        this.makeFence((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeFence((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeFence((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeFenceGate((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE_GATE, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeFenceGate((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE_GATE, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeFenceGate((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE_GATE, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeDoor((Supplier<? extends Block>)UGBlocks.SMOGSTEM_DOOR, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeDoor((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_DOOR, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeDoor((Supplier<? extends Block>)UGBlocks.GRONGLE_DOOR, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeTrapdoor((Supplier<? extends Block>)UGBlocks.SMOGSTEM_TRAPDOOR, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeTrapdoor((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_TRAPDOOR, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeTrapdoor((Supplier<? extends Block>)UGBlocks.GRONGLE_TRAPDOOR, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.SMOGSTEM_BUTTON, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_BUTTON, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.GRONGLE_BUTTON, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BUTTON, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BUTTON, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makeButton((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BUTTON, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.GRONGLE_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.DEPTHROCK_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.DEPTHROCK).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.SHIVERSTONE).save(consumer);
        this.makePressurePlate((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_PRESSURE_PLATE, (Supplier<? extends Block>)UGBlocks.TREMBLECRUST).save(consumer);
        this.makeStew((Supplier<? extends Item>)UGItems.BLOODY_STEW, (Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM).save(consumer);
        this.makeStew((Supplier<? extends Item>)UGItems.INKY_STEW, (Supplier<? extends Block>)UGBlocks.INK_MUSHROOM).save(consumer);
        this.makeStew((Supplier<? extends Item>)UGItems.INDIGO_STEW, (Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM).save(consumer);
        this.makeStew((Supplier<? extends Item>)UGItems.VEILED_STEW, (Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)UGItems.SLOP_BOWL.get())).requires((ItemLike)Items.BOWL).requires((ItemLike)UGItems.UNDERBEANS.get(), 2).requires((ItemLike)UGItems.MOGMOSS.get(), 2).unlockedBy("has_underbeans", UGRecipes.has((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).unlockedBy("has_mogmoss", UGRecipes.has((ItemLike)((ItemLike)UGItems.MOGMOSS.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)UGItems.SLOP_BOWL.get())).requires((ItemLike)Items.BOWL).requires((ItemLike)UGItems.UNDERBEANS.get(), 2).requires((ItemLike)UGItems.BLUE_MOGMOSS.get(), 2).unlockedBy("has_underbeans", UGRecipes.has((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).unlockedBy("has_blue_mogmoss", UGRecipes.has((ItemLike)((ItemLike)UGItems.BLUE_MOGMOSS.get()))).save(consumer, this.name("slop_bowl_blue_moss"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get()), (int)2).pattern("DTD").pattern("DRD").pattern("DDD").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('R'), (ItemLike)UGBlocks.DEPTHROCK.get()).define(Character.valueOf('T'), (ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get()).unlockedBy("has_template", UGRecipes.has((ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get()))).save(consumer);
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_SWORD, (Supplier<Item>)UGItems.FORGOTTEN_SWORD).save(consumer, this.name("forgotten_sword_smithing"));
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_PICKAXE, (Supplier<Item>)UGItems.FORGOTTEN_PICKAXE).save(consumer, this.name("forgotten_pickaxe_smithing"));
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_AXE, (Supplier<Item>)UGItems.FORGOTTEN_AXE).save(consumer, this.name("forgotten_axe_smithing"));
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_SHOVEL, (Supplier<Item>)UGItems.FORGOTTEN_SHOVEL).save(consumer, this.name("forgotten_shovel_smithing"));
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_HOE, (Supplier<Item>)UGItems.FORGOTTEN_HOE).save(consumer, this.name("forgotten_hoe_smithing"));
        this.smithingForgotten((Supplier<Item>)UGItems.CLOGGRUM_BATTLEAXE, (Supplier<Item>)UGItems.FORGOTTEN_BATTLEAXE).save(consumer, this.name("forgotten_battleaxe_smithing"));
        this.smeltingRecipe((ItemLike)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get(), (ItemLike)UGBlocks.DEPTHROCK_BRICKS.get(), 0.1f).save(consumer, this.name("smelt_depthrock_bricks"));
        this.smeltingRecipe((ItemLike)UGBlocks.CRACKED_SHIVERSTONE_BRICKS.get(), (ItemLike)UGBlocks.SHIVERSTONE_BRICKS.get(), 0.1f).save(consumer, this.name("smelt_shiverstone_bricks"));
        this.smeltingRecipe((ItemLike)UGBlocks.CRACKED_TREMBLECRUST_BRICKS.get(), (ItemLike)UGBlocks.TREMBLECRUST_BRICKS.get(), 0.1f).save(consumer, this.name("smelt_tremblecrust_bricks"));
        this.smeltingRecipe((ItemLike)UGBlocks.SEDIMENT_GLASS.get(), (ItemLike)UGBlocks.SEDIMENT.get(), 0.1f).save(consumer);
        this.smeltingRecipe((ItemLike)Items.DIAMOND, (ItemLike)UGItems.CATALYST.get(), 0.0f).save(consumer, this.name("smelt_catalyst"));
        this.blastingRecipe((ItemLike)Items.DIAMOND, (ItemLike)UGItems.CATALYST.get(), 0.0f).save(consumer, this.name("blast_catalyst"));
        this.ore((ItemLike)Items.COAL, (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_COAL_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_COAL_ORE.get())), 0.1f, "coal", consumer);
        this.ore((ItemLike)Items.IRON_INGOT, (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_IRON_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_IRON_ORE.get())), 0.7f, "iron_ingot", consumer);
        this.ore((ItemLike)Items.GOLD_INGOT, (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_GOLD_ORE.get())), 1.0f, "gold_ingot", consumer);
        this.ore((ItemLike)Items.DIAMOND, (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_DIAMOND_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_DIAMOND_ORE.get())), 1.0f, "diamond", consumer);
        this.ore((ItemLike)UGItems.CLOGGRUM_INGOT.get(), (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGItems.RAW_CLOGGRUM.get()), (Object)((ItemLike)UGBlocks.DEPTHROCK_CLOGGRUM_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE.get())), 0.7f, "undergarden:cloggrum_ingot", consumer);
        this.ore((ItemLike)UGItems.FROSTSTEEL_INGOT.get(), (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGItems.RAW_FROSTSTEEL.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE.get())), 0.7f, "undergarden:froststeel_ingot", consumer);
        this.ore((ItemLike)UGItems.UTHERIUM_CRYSTAL.get(), (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_UTHERIUM_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_UTHERIUM_ORE.get())), 1.0f, "undergarden:utherium", consumer);
        this.ore((ItemLike)UGItems.REGALIUM_CRYSTAL.get(), (List<ItemLike>)ImmutableList.of((Object)((ItemLike)UGBlocks.DEPTHROCK_REGALIUM_ORE.get()), (Object)((ItemLike)UGBlocks.SHIVERSTONE_REGALIUM_ORE.get())), 1.0f, "undergarden:regalium_crystal", consumer);
        this.smeltingRecipeTag((ItemLike)UGItems.CLOGGRUM_NUGGET.get(), UGTags.Items.CLOGGRUM_ITEMS, 0.1f).save(consumer, this.name("smelt_cloggrum_item"));
        this.blastingRecipeTag((ItemLike)UGItems.CLOGGRUM_NUGGET.get(), UGTags.Items.CLOGGRUM_ITEMS, 0.1f).save(consumer, this.name("blast_cloggrum_item"));
        this.smeltingRecipeTag((ItemLike)UGItems.FROSTSTEEL_INGOT.get(), UGTags.Items.FROSTSTEEL_ITEMS, 0.1f).save(consumer, this.name("smelt_froststeel_item"));
        this.blastingRecipeTag((ItemLike)UGItems.FROSTSTEEL_INGOT.get(), UGTags.Items.FROSTSTEEL_ITEMS, 0.1f).save(consumer, this.name("blast_froststeel_item"));
        this.smeltingRecipeTag((ItemLike)UGItems.UTHERIUM_CRYSTAL.get(), UGTags.Items.UTHERIUM_ITEMS, 0.1f).save(consumer, this.name("smelt_utherium_item"));
        this.blastingRecipeTag((ItemLike)UGItems.UTHERIUM_CRYSTAL.get(), UGTags.Items.UTHERIUM_ITEMS, 0.1f).save(consumer, this.name("blast_utherium_item"));
        this.smeltingRecipe((ItemLike)UGItems.DWELLER_STEAK.get(), (ItemLike)UGItems.RAW_DWELLER_MEAT.get(), 0.35f).save(consumer, this.name("smelt_dweller_meat"));
        this.smokingRecipe((ItemLike)UGItems.DWELLER_STEAK.get(), (ItemLike)UGItems.RAW_DWELLER_MEAT.get(), 0.35f).save(consumer, this.name("smoke_dweller_meat"));
        this.smeltingRecipe((ItemLike)UGItems.COOKED_GWIBLING.get(), (ItemLike)UGItems.RAW_GWIBLING.get(), 0.35f).save(consumer, this.name("smelt_gwibling"));
        this.smokingRecipe((ItemLike)UGItems.COOKED_GWIBLING.get(), (ItemLike)UGItems.RAW_GWIBLING.get(), 0.35f).save(consumer, this.name("smoke_gwibling"));
        this.smeltingRecipe((ItemLike)UGItems.GLOOMPER_LEG.get(), (ItemLike)UGItems.RAW_GLOOMPER_LEG.get(), 0.35f).save(consumer, this.name("smelt_gloomper_leg"));
        this.smokingRecipe((ItemLike)UGItems.GLOOMPER_LEG.get(), (ItemLike)UGItems.RAW_GLOOMPER_LEG.get(), 0.35f).save(consumer, this.name("smoke_gloomper_leg"));
        this.smeltingRecipe((ItemLike)Items.DRIED_KELP, (ItemLike)UGItems.GLITTERKELP.get(), 0.1f).save(consumer, this.name("smelt_glitterkelp"));
        this.smokingRecipe((ItemLike)Items.DRIED_KELP, (ItemLike)UGItems.GLITTERKELP.get(), 0.1f).save(consumer, this.name("smoke_glitterkelp"));
        this.smeltingRecipe((ItemLike)UGItems.ROASTED_UNDERBEANS.get(), (ItemLike)UGItems.UNDERBEANS.get(), 0.35f).save(consumer, this.name("smelt_underbeans"));
        this.smokingRecipe((ItemLike)UGItems.ROASTED_UNDERBEANS.get(), (ItemLike)UGItems.UNDERBEANS.get(), 0.35f).save(consumer, this.name("smoke_underbeans"));
        this.depthrockStonecutting((ItemLike)UGBlocks.CHISELED_DEPTHROCK_BRICKS.get()).save(consumer, this.name("chiseled_depthrock_bricks_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_SLAB.get(), 2).save(consumer, this.name("depthrock_brick_slab_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_STAIRS.get()).save(consumer, this.name("depthrock_brick_stairs_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_WALL.get()).save(consumer, this.name("depthrock_brick_wall_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICKS.get()).save(consumer, this.name("depthrock_bricks_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_SLAB.get(), 2).save(consumer, this.name("depthrock_slab_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_STAIRS.get()).save(consumer, this.name("depthrock_stairs_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_WALL.get()).save(consumer, this.name("depthrock_wall_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_TILES.get()).save(consumer, this.name("depthrock_tiles_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_TILE_STAIRS.get()).save(consumer, this.name("depthrock_tile_stairs_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.DEPTHROCK_TILE_SLAB.get(), 2).save(consumer, this.name("depthrock_tile_slab_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK.get()).save(consumer, this.name("polished_depthrock_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_SLAB.get(), 2).save(consumer, this.name("polished_depthrock_slab_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_STAIRS.get()).save(consumer, this.name("polished_depthrock_stairs_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_WALL.get()).save(consumer, this.name("polished_depthrock_wall_stonecutting"));
        this.depthrockStonecutting((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), 9).save(consumer, this.name("depthrock_pebble_stonecutting"));
        this.depthrockBricksStonecutting((ItemLike)UGBlocks.CHISELED_DEPTHROCK_BRICKS.get()).save(consumer, this.name("depthrock_bricks_to_chiseled_depthrock_bricks_stonecutting"));
        this.depthrockBricksStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_SLAB.get(), 2).save(consumer, this.name("depthrock_bricks_to_depthrock_brick_slab_stonecutting"));
        this.depthrockBricksStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_STAIRS.get()).save(consumer, this.name("depthrock_bricks_to_depthrock_brick_stairs_stonecutting"));
        this.depthrockBricksStonecutting((ItemLike)UGBlocks.DEPTHROCK_BRICK_WALL.get()).save(consumer, this.name("depthrock_bricks_to_depthrock_brick_wall_stonecutting"));
        this.depthrockTilesStonecutting((ItemLike)UGBlocks.DEPTHROCK_TILE_STAIRS.get()).save(consumer, this.name("depthrock_tiles_to_depthrock_tile_stairs_stonecutting"));
        this.depthrockTilesStonecutting((ItemLike)UGBlocks.DEPTHROCK_TILE_SLAB.get(), 2).save(consumer, this.name("depthrock_tiles_to_depthrock_tile_slab_stonecutting"));
        this.polishedDepthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_SLAB.get(), 2).save(consumer, this.name("polished_depthrock_to_polished_depthrock_slab_stonecutting"));
        this.polishedDepthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_STAIRS.get()).save(consumer, this.name("polished_depthrock_to_polished_depthrock_stairs_stonecutting"));
        this.polishedDepthrockStonecutting((ItemLike)UGBlocks.POLISHED_DEPTHROCK_WALL.get()).save(consumer, this.name("polished_depthrock_to_polished_depthrock_wall_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.CHISELED_SHIVERSTONE_BRICKS.get()).save(consumer, this.name("chiseled_shiverstone_bricks_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_SLAB.get(), 2).save(consumer, this.name("shiverstone_brick_slab_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_STAIRS.get()).save(consumer, this.name("shiverstone_brick_stairs_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_WALL.get()).save(consumer, this.name("shiverstone_brick_wall_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICKS.get()).save(consumer, this.name("shiverstone_bricks_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_SLAB.get(), 2).save(consumer, this.name("shiverstone_slab_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_STAIRS.get()).save(consumer, this.name("shiverstone_stairs_stonecutting"));
        this.shiverstoneStonecutting((ItemLike)UGBlocks.SHIVERSTONE_WALL.get()).save(consumer, this.name("shiverstone_wall_stonecutting"));
        this.shiverstoneBricksStonecutting((ItemLike)UGBlocks.CHISELED_SHIVERSTONE_BRICKS.get()).save(consumer, this.name("shiverstone_bricks_to_chiseled_shiverstone_bricks_stonecutting"));
        this.shiverstoneBricksStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_SLAB.get(), 2).save(consumer, this.name("shiverstone_bricks_to_shiverstone_brick_slab_stonecutting"));
        this.shiverstoneBricksStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_STAIRS.get()).save(consumer, this.name("shiverstone_bricks_to_shiverstone_brick_stairs_stonecutting"));
        this.shiverstoneBricksStonecutting((ItemLike)UGBlocks.SHIVERSTONE_BRICK_WALL.get()).save(consumer, this.name("shiverstone_bricks_to_shiverstone_brick_wall_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.CHISELED_TREMBLECRUST_BRICKS.get()).save(consumer, this.name("chiseled_tremblecrust_bricks_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_SLAB.get(), 2).save(consumer, this.name("tremblecrust_brick_slab_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_STAIRS.get()).save(consumer, this.name("tremblecrust_brick_stairs_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_WALL.get()).save(consumer, this.name("tremblecrust_brick_wall_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICKS.get()).save(consumer, this.name("tremblecrust_bricks_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_SLAB.get(), 2).save(consumer, this.name("tremblecrust_slab_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_STAIRS.get()).save(consumer, this.name("tremblecrust_stairs_stonecutting"));
        this.tremblecrustStonecutting((ItemLike)UGBlocks.TREMBLECRUST_WALL.get()).save(consumer, this.name("tremblecrust_wall_stonecutting"));
        this.tremblecrustBricksStonecutting((ItemLike)UGBlocks.CHISELED_TREMBLECRUST_BRICKS.get()).save(consumer, this.name("tremblecrust_bricks_to_chiseled_tremblecrust_bricks_stonecutting"));
        this.tremblecrustBricksStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_SLAB.get(), 2).save(consumer, this.name("tremblecrust_bricks_to_tremblecrust_brick_slab_stonecutting"));
        this.tremblecrustBricksStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_STAIRS.get()).save(consumer, this.name("tremblecrust_bricks_to_tremblecrust_brick_stairs_stonecutting"));
        this.tremblecrustBricksStonecutting((ItemLike)UGBlocks.TREMBLECRUST_BRICK_WALL.get()).save(consumer, this.name("tremblecrust_bricks_to_tremblecrust_brick_wall_stonecutting"));
    }

    private ResourceLocation name(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)name);
    }
}

