/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import quek.undergarden.entity.Boomgourd;
import quek.undergarden.registry.UGBlocks;

public class BoomgourdRender
extends EntityRenderer<Boomgourd> {
    private final BlockRenderDispatcher blockRenderer;

    public BoomgourdRender(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(Boomgourd entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.translate(0.0, 0.5, 0.0);
        int fuse = entity.getFuse();
        if ((float)fuse - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)fuse - partialTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            stack.scale(f1, f1, f1);
        }
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.translate(-0.5, -0.5, 0.5);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)((Block)UGBlocks.BOOMGOURD.get()).defaultBlockState(), (PoseStack)stack, (MultiBufferSource)buffer, (int)light, (fuse / 5 % 2 == 0 ? 1 : 0) != 0);
        stack.popPose();
        super.render((Entity)entity, yaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(Boomgourd entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

