/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SnowflakeParticle
extends TextureSheetParticle {
    private float rotSpeed;
    private final float spinAcceleration;

    protected SnowflakeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 1.0f;
        this.xd += xSpeed * 0.05;
        this.zd += zSpeed * 0.05;
        this.xd *= (double)0.0075f;
        this.yd = 0.0;
        this.zd *= (double)0.0075f;
        this.gravity = 5.0E-4f;
        this.lifetime = 80;
        this.quadSize *= 0.5f;
        this.hasPhysics = true;
        this.rotSpeed = (float)Math.toRadians(this.random.nextBoolean() ? -60.0 : 60.0);
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -25.0 : 25.0);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.rotSpeed += this.spinAcceleration / 20.0f;
            this.oRoll = this.roll;
            this.roll += this.rotSpeed / 20.0f;
            if (!this.onGround) {
                this.move(this.xd, this.yd, this.zd);
            } else {
                this.age = Math.max(this.lifetime - 10, this.age);
            }
            if (this.age > this.lifetime - 10) {
                this.scale((float)Mth.abs((int)(this.age - this.lifetime)) * 0.1f);
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SnowflakeParticle snow = new SnowflakeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            snow.pickSprite(this.spriteSet);
            return snow;
        }
    }
}

