/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SmogMogModel<E extends Entity>
extends AgeableListModel<E> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart frontLegLeft;
    private final ModelPart frontLegRight;
    private final ModelPart backLegLeft;
    private final ModelPart backLegRight;

    public SmogMogModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.frontLegLeft = root.getChild("left_front_leg");
        this.frontLegRight = root.getChild("right_front_leg");
        this.backLegLeft = root.getChild("left_back_leg");
        this.backLegRight = root.getChild("right_back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -16.0f, -7.0f, 14.0f, 12.0f, 14.0f).texOffs(0, 26).addBox(-5.0f, -28.0f, -5.0f, 10.0f, 12.0f, 10.0f).texOffs(42, 0).addBox(-8.0f, -17.0f, -8.0f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 26).addBox(-3.0f, -3.0f, -2.0f, 6.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 48).addBox(0.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f), PartPose.offset((float)4.0f, (float)19.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-4.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f), PartPose.offset((float)-4.0f, (float)19.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(0.0f, 0.0f, -4.0f, 4.0f, 5.0f, 4.0f).mirror(false), PartPose.offset((float)4.0f, (float)19.0f, (float)8.0f));
        partdefinition.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(32, 48).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f), PartPose.offset((float)-4.0f, (float)19.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.frontLegLeft, (Object)this.frontLegRight, (Object)this.backLegLeft, (Object)this.backLegRight);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.zRot = 0.1f * Mth.sin((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegLeft.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegRight.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegLeft.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegRight.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
    }
}

