/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.cavern.Nargoyle;

public class NargoyleModel<T extends Nargoyle>
extends ListModel<T> {
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart lowerBody;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart legs;
    private final ModelPart jaw;

    public NargoyleModel(ModelPart root) {
        this.body = root.getChild("body");
        this.upperBody = this.body.getChild("upperbody");
        this.lowerBody = this.body.getChild("lowerbody");
        this.head = this.upperBody.getChild("head");
        this.arms = this.upperBody.getChild("arms");
        this.legs = this.lowerBody.getChild("legs");
        this.jaw = this.head.getChild("jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition upperbody = body.addOrReplaceChild("upperbody", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -11.0f, 0.0f, 10.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition head = upperbody.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 51).addBox(-4.0f, -9.5f, -2.0f, 8.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(16, 28).addBox(-3.0f, -8.5f, -4.0f, 6.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(45, 49).addBox(-2.0f, -9.5f, 1.0f, 4.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.5f, (float)3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(34, 35).addBox(-4.0f, -7.5f, -1.0f, 8.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-2.0f, -6.5f, 0.0f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition ear1 = head.addOrReplaceChild("ear1", CubeListBuilder.create().texOffs(0, 54).addBox(-5.0f, -1.0f, -1.0f, 3.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition ear2 = head.addOrReplaceChild("ear2", CubeListBuilder.create().texOffs(0, 54).mirror().addBox(-1.5f, 0.0f, -6.0f, 3.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)-1.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition arms = upperbody.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-7.4927f, (float)3.3309f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperarmleft = arms.addOrReplaceChild("upperarmleft", CubeListBuilder.create().texOffs(34, 0).addBox(5.0f, -9.9927f, -0.9691f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0073f, (float)-0.0309f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerarmleft = upperarmleft.addOrReplaceChild("lowerarmleft", CubeListBuilder.create().texOffs(34, 43).addBox(-1.5f, -14.7194f, -1.2086f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-9.9927f, (float)1.0309f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition upperarmright = arms.addOrReplaceChild("upperarmright", CubeListBuilder.create().texOffs(34, 0).mirror().addBox(-8.0f, -9.9927f, -0.6691f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-0.0073f, (float)-0.3309f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerarmright = upperarmright.addOrReplaceChild("lowerarmright", CubeListBuilder.create().texOffs(34, 43).mirror().addBox(-0.5f, -14.7194f, -1.2086f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)-9.9927f, (float)1.3309f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition lowerbody = body.addOrReplaceChild("lowerbody", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)5.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition hips = lowerbody.addOrReplaceChild("hips", CubeListBuilder.create().texOffs(21, 21).addBox(-3.0f, -4.0f, 2.0f, 6.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.7189f, (float)-1.2679f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition legs = lowerbody.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-2.527f, (float)6.4479f, (float)-1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition upperrightleg = legs.addOrReplaceChild("upperrightleg", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-5.0f, -9.027f, -1.0521f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.027f, (float)-0.9479f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerrightleg = upperrightleg.addOrReplaceChild("lowerrightleg", CubeListBuilder.create().texOffs(0, 31).addBox(-1.5f, -8.8618f, -0.8628f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-8.2609f, (float)-0.6949f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition upperleftleg = legs.addOrReplaceChild("upperleftleg", CubeListBuilder.create().texOffs(0, 18).addBox(3.0f, -9.027f, -1.0521f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.027f, (float)-0.9479f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerleftleg = upperleftleg.addOrReplaceChild("lowerleftleg", CubeListBuilder.create().texOffs(0, 31).addBox(0.5f, -8.8618f, -0.8628f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-8.2609f, (float)-0.6949f, (float)1.2217f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = headPitch * ((float)Math.PI / 180);
        this.head.xRot = 0.4363f + headPitch * ((float)Math.PI / 180);
        this.arms.xRot = 1.5708f + Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legs.xRot = -1.7017f + -(Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        this.jaw.xRot = entity.isAggressive() ? 0.3491f : 0.0f;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.body);
    }
}

