/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.cavern.Muncher;

public class MuncherModel<T extends Muncher>
extends ListModel<T> {
    private final ModelPart lowerJaw;
    private final ModelPart upperJaw;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public MuncherModel(ModelPart root) {
        this.lowerJaw = root.getChild("lowerJaw");
        this.upperJaw = root.getChild("upperJaw");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
        this.leftArm = root.getChild("leftArm");
        this.rightArm = root.getChild("rightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition lowerJaw = partdefinition.addOrReplaceChild("lowerJaw", CubeListBuilder.create().texOffs(0, 15).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-8.0f, -5.0f, 3.0f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition upperJaw = partdefinition.addOrReplaceChild("upperJaw", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.0f, -10.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(0.0f, -6.0f, -6.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(30, 15).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)20.0f, (float)1.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)20.0f, (float)1.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)18.0f, (float)2.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)18.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.upperJaw.xRot = Mth.sin((float)((float)((Muncher)((Object)entity)).tickCount * 0.5f)) * 0.9f * 0.3f;
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.lowerJaw, (Object)this.upperJaw, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.leftArm, (Object)this.rightArm, (Object[])new ModelPart[0]);
    }
}

