/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaRegistry;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class JsonRecipeSchemaLoader {
    public static void load(RecipeSchemaStorage storage, RegistryAccessContainer registries, RecipeSchemaRegistry event, ResourceManager resourceManager) {
        HashMap<ResourceLocation, RecipeSchemaBuilder> map = new HashMap<ResourceLocation, RecipeSchemaBuilder>();
        for (Map.Entry entry : resourceManager.listResources("kubejs/recipe_schema", path -> path.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                    RecipeSchemaBuilder holder = new RecipeSchemaBuilder(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)((ResourceLocation)entry.getKey()).getPath().substring("kubejs/recipe_schema/".length(), ((ResourceLocation)entry.getKey()).getPath().length() - ".json".length())), json);
                    map.put(holder.id, holder);
                    if (!holder.json.has("mappings")) continue;
                    for (JsonElement m : holder.json.getAsJsonArray("mappings")) {
                        storage.mappings.put(m.getAsString(), holder.id);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception ex) {
                ConsoleJS.SERVER.error("Error reading recipe schema json " + String.valueOf(entry.getKey()), ex);
            }
        }
        for (RecipeSchemaBuilder holder : map.values()) {
            if (holder.json.has("hidden")) {
                holder.hidden = holder.json.get("hidden").getAsBoolean();
            }
            RecipeSchemaBuilder recipeSchemaBuilder = holder.parent = holder.json.has("parent") ? (RecipeSchemaBuilder)map.get(ResourceLocation.parse((String)holder.json.get("parent").getAsString())) : null;
            if (holder.json.has("override_type")) {
                holder.overrideType = ResourceLocation.parse((String)holder.json.get("override_type").getAsString());
            }
            if (holder.json.has("factory")) {
                ResourceLocation fname = ResourceLocation.parse((String)holder.json.get("factory").getAsString());
                holder.recipeFactory = storage.recipeTypes.get(fname);
                if (holder.recipeFactory == null) {
                    throw new NullPointerException("Recipe factory '" + String.valueOf(fname) + "' not found for recipe schema '" + String.valueOf(holder.id) + "'");
                }
            }
            if (holder.json.has("keys")) {
                holder.keys = new ArrayList();
                for (Object entry : holder.json.getAsJsonArray("keys")) {
                    try {
                        JsonArray arr;
                        JsonObject keyJson = entry.getAsJsonObject();
                        String name = keyJson.get("name").getAsString();
                        ComponentRole role = switch (keyJson.has("role") ? keyJson.get("role").getAsString() : "") {
                            case "input" -> ComponentRole.INPUT;
                            case "output" -> ComponentRole.OUTPUT;
                            default -> ComponentRole.OTHER;
                        };
                        RecipeComponent<?> type = storage.getComponent(registries, keyJson.get("type").getAsString());
                        RecipeKey<?> key = type.key(name, role);
                        if (keyJson.has("optional")) {
                            JsonElement optionalJson = keyJson.get("optional");
                            if (optionalJson == null || optionalJson.isJsonNull()) {
                                key.defaultOptional();
                            } else {
                                try {
                                    key.optional = new RecipeOptional.Constant<Object>(((Pair)key.codec.decode(registries.json(), (Object)optionalJson).getOrThrow()).getFirst());
                                }
                                catch (Exception ex) {
                                    throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key) + "' of '" + String.valueOf(holder.id) + "' from " + String.valueOf(optionalJson), ex);
                                }
                            }
                        }
                        if (keyJson.has("alternative_names")) {
                            arr = keyJson.getAsJsonArray("alternative_names");
                            for (JsonElement e : arr) {
                                key.names.add(e.getAsString());
                            }
                        }
                        if (keyJson.has("excluded")) {
                            key.excluded = keyJson.get("excluded").getAsBoolean();
                        }
                        if (keyJson.has("function_names")) {
                            arr = keyJson.getAsJsonArray("function_names");
                            key.functionNames = new ArrayList<String>(arr.size());
                            for (JsonElement e : arr) {
                                key.functionNames.add(e.getAsString());
                            }
                        }
                        if (keyJson.has("allow_empty")) {
                            key.allowEmpty = keyJson.get("allow_empty").getAsBoolean();
                        }
                        if (keyJson.has("always_write")) {
                            key.alwaysWrite = keyJson.get("always_write").getAsBoolean();
                        }
                        holder.keys.add(key);
                    }
                    catch (Exception ex) {
                        ConsoleJS.SERVER.error("Error parsing recipe schema '" + String.valueOf(holder.id) + "' key " + String.valueOf(entry), ex);
                    }
                }
            }
            if (holder.json.has("constructors")) {
                for (Object entry : holder.json.getAsJsonArray("constructors")) {
                    JsonObject c = entry.getAsJsonObject();
                    ConstructorBuilder constructor = new ConstructorBuilder(new ArrayList<String>(3), new HashMap<String, JsonElement>(0));
                    for (Object e : c.getAsJsonArray("keys")) {
                        constructor.keys.add(e.getAsString());
                    }
                    if (c.has("overrides")) {
                        for (Object e : c.getAsJsonObject("overrides").entrySet()) {
                            constructor.overrides.put((String)e.getKey(), (JsonElement)e.getValue());
                        }
                    }
                    if (holder.constructors == null) {
                        holder.constructors = new ArrayList<ConstructorBuilder>();
                    }
                    holder.constructors.add(constructor);
                }
            }
            if (holder.json.has("unique")) {
                Object entry;
                JsonArray arr = holder.json.getAsJsonArray("unique");
                holder.unique = new ArrayList<String>(arr.size());
                entry = arr.iterator();
                while (entry.hasNext()) {
                    JsonElement e = (JsonElement)entry.next();
                    holder.unique.add(e.getAsString());
                }
            }
            if (holder.json.has("functions")) {
                holder.functions = new HashMap<String, FunctionBuilder>();
                for (Object entry : holder.json.getAsJsonObject("functions").entrySet()) {
                    holder.functions.put((String)entry.getKey(), new FunctionBuilder((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
                }
            }
            if (!holder.json.has("override_keys")) continue;
            holder.overrideKeys = new HashMap<String, JsonElement>();
            for (Map.Entry e : holder.json.getAsJsonObject("override_keys").entrySet()) {
                holder.overrideKeys.put((String)e.getKey(), (JsonElement)e.getValue());
            }
        }
        for (RecipeSchemaBuilder holder : map.values()) {
            RecipeSchema schema = holder.getSchema((DynamicOps<JsonElement>)registries.json());
            event.namespace(holder.id.getNamespace()).register(holder.id.getPath(), schema);
        }
    }

    private static final class RecipeSchemaBuilder {
        private final ResourceLocation id;
        private final JsonObject json;
        private RecipeSchema schema;
        private RecipeSchemaBuilder parent;
        private ResourceLocation overrideType;
        private List<RecipeKey<?>> keys;
        private List<ConstructorBuilder> constructors;
        private Map<String, FunctionBuilder> functions;
        private KubeRecipeFactory recipeFactory;
        private List<String> unique;
        private boolean hidden;
        private Map<String, JsonElement> overrideKeys;

        private RecipeSchemaBuilder(ResourceLocation id, JsonObject json) {
            this.id = id;
            this.json = json;
        }

        private List<RecipeKey<?>> getKeys() {
            if (this.keys != null) {
                return this.keys;
            }
            if (this.parent != null) {
                return this.parent.getKeys();
            }
            return List.of();
        }

        private List<ConstructorBuilder> getConstructors() {
            if (this.constructors != null) {
                return this.constructors;
            }
            if (this.parent != null) {
                return this.parent.getConstructors();
            }
            return List.of();
        }

        private void gatherFunctions(Map<String, FunctionBuilder> list) {
            if (this.parent != null) {
                this.parent.gatherFunctions(list);
            }
            if (this.functions != null) {
                list.putAll(this.functions);
            }
        }

        private KubeRecipeFactory getRecipeFactory() {
            if (this.recipeFactory != null) {
                return this.recipeFactory;
            }
            if (this.parent != null) {
                return this.parent.getRecipeFactory();
            }
            return null;
        }

        private List<String> getUnique() {
            if (this.unique != null) {
                return this.unique;
            }
            if (this.parent != null) {
                return this.parent.getUnique();
            }
            return List.of();
        }

        private boolean isHidden() {
            if (this.hidden) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isHidden();
            }
            return false;
        }

        private RecipeSchema getSchema(DynamicOps<JsonElement> jsonOps) {
            if (this.schema == null) {
                if (this.overrideType != null || this.keys != null || this.constructors != null || this.functions != null || this.recipeFactory != null || this.unique != null || this.overrideKeys != null) {
                    RecipeKey key;
                    List<ConstructorBuilder> constructors;
                    List<RecipeKey<?>> keys = this.getKeys();
                    HashMap keyMap = new HashMap();
                    for (RecipeKey<?> key2 : keys) {
                        keyMap.put(key2.name, key2);
                    }
                    HashMap<String, FunctionBuilder> functionMap = new HashMap<String, FunctionBuilder>();
                    this.gatherFunctions(functionMap);
                    Reference2ObjectOpenHashMap keyOverrides = new Reference2ObjectOpenHashMap(this.overrideKeys == null ? 0 : this.overrideKeys.size());
                    if (this.overrideKeys != null) {
                        for (Map.Entry<String, JsonElement> entry : this.overrideKeys.entrySet()) {
                            RecipeKey key3 = (RecipeKey)keyMap.get(entry.getKey());
                            if (key3 != null) {
                                try {
                                    keyOverrides.put((Object)key3, new RecipeOptional.Constant<Object>(((Pair)key3.codec.decode(jsonOps, (Object)entry.getValue()).getOrThrow()).getFirst()));
                                    continue;
                                }
                                catch (Exception ex) {
                                    throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key3) + "' of '" + String.valueOf(this.id) + "' from " + String.valueOf(entry.getValue()), ex);
                                }
                            }
                            throw new NullPointerException("Key '" + entry.getKey() + "' not found in key overrides of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                    }
                    this.schema = new RecipeSchema((Map<RecipeKey<?>, RecipeOptional<?>>)keyOverrides, this.getKeys());
                    this.schema.typeOverride = this.overrideType;
                    KubeRecipeFactory rf = this.getRecipeFactory();
                    if (rf != null) {
                        this.schema.recipeFactory = rf;
                    }
                    if (!(constructors = this.getConstructors()).isEmpty()) {
                        for (ConstructorBuilder c : constructors) {
                            ArrayList<RecipeKey> cKeys = new ArrayList<RecipeKey>();
                            for (String string : c.keys) {
                                key = (RecipeKey)keyMap.get(string);
                                if (key != null) {
                                    cKeys.add(key);
                                    continue;
                                }
                                throw new NullPointerException("Key '" + string + "' not found in constructor of recipe schema '" + String.valueOf(this.id) + "'");
                            }
                            RecipeConstructor constructor = new RecipeConstructor(cKeys.toArray(new RecipeKey[0]));
                            if (!c.overrides.isEmpty()) {
                                constructor.overrides = new Reference2ObjectOpenHashMap(c.overrides.size());
                                for (Map.Entry<String, JsonElement> entry : c.overrides.entrySet()) {
                                    RecipeKey key4 = (RecipeKey)keyMap.get(entry.getKey());
                                    if (key4 != null) {
                                        try {
                                            constructor.overrides.put(key4, new RecipeOptional.Constant<Object>(((Pair)key4.codec.decode(jsonOps, (Object)((JsonElement)entry.getValue())).getOrThrow()).getFirst()));
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            throw new IllegalArgumentException("Failed to create optional value for key '" + String.valueOf(key4) + "' of '" + String.valueOf(this.id) + "' from " + String.valueOf(entry.getValue()), ex);
                                        }
                                    }
                                    throw new NullPointerException("Key '" + (String)entry.getKey() + "' not found in overrides of constructor of recipe schema '" + String.valueOf(this.id) + "'");
                                }
                            }
                            this.schema.constructor(constructor);
                        }
                    }
                    for (Map.Entry<String, FunctionBuilder> entry : functionMap.entrySet()) {
                        String funcName = entry.getKey();
                        JsonObject funcJson = entry.getValue().json;
                        if (funcJson.has("set")) {
                            HashMap hashMap = new HashMap(1);
                            for (Map.Entry entry1 : funcJson.getAsJsonObject("set").entrySet()) {
                                String keyName3 = (String)entry1.getKey();
                                RecipeKey key5 = (RecipeKey)keyMap.get(keyName3);
                                if (key5 != null) {
                                    hashMap.put(key5, ((Pair)key5.codec.decode(jsonOps, (Object)((JsonElement)entry1.getValue())).getOrThrow()).getFirst());
                                    continue;
                                }
                                throw new NullPointerException("Key '" + keyName3 + "' not found in function '" + funcName + "' of recipe schema '" + String.valueOf(this.id) + "'");
                            }
                            if (hashMap.size() == 1) {
                                this.schema.function(funcName, new RecipeSchemaFunction.SetFunction((RecipeKey)hashMap.keySet().iterator().next(), hashMap.values().iterator().next()));
                            } else if (!hashMap.isEmpty()) {
                                this.schema.function(funcName, new RecipeSchemaFunction.SetManyFunction(hashMap));
                            }
                        }
                        if (!funcJson.has("add_to_list")) continue;
                        String string = funcJson.get("add_to_list").getAsString();
                        key = (RecipeKey)keyMap.get(string);
                        if (key != null) {
                            this.schema.function(funcName, new RecipeSchemaFunction.AddToListFunction(key));
                            continue;
                        }
                        throw new NullPointerException("Key '" + string + "' not found in function '" + funcName + "' of recipe schema '" + String.valueOf(this.id) + "'");
                    }
                    List<String> uniqueKeyNames = this.getUnique();
                    if (!uniqueKeyNames.isEmpty()) {
                        ArrayList uniqueKeys = new ArrayList();
                        for (String keyName4 : uniqueKeyNames) {
                            RecipeKey recipeKey = (RecipeKey)keyMap.get(keyName4);
                            if (recipeKey != null) {
                                uniqueKeys.add(recipeKey);
                                continue;
                            }
                            throw new NullPointerException("Key '" + keyName4 + "' not found in unique keys of recipe schema '" + String.valueOf(this.id) + "'");
                        }
                        this.schema.uniqueIds(uniqueKeys);
                    }
                    this.schema.hidden = this.isHidden();
                } else if (this.parent != null) {
                    this.schema = this.parent.getSchema(jsonOps);
                } else {
                    this.schema = new RecipeSchema(Map.of(), List.of());
                    this.schema.constructor(new RecipeKey[0]);
                }
            }
            return this.schema;
        }
    }

    private record ConstructorBuilder(List<String> keys, Map<String, JsonElement> overrides) {
    }

    private record FunctionBuilder(String name, JsonObject json) {
    }
}

