/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockRenderType;
import dev.latvian.mods.kubejs.client.BlockEntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.BlockTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.EntityRendererRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.ItemTintFunctionWrapper;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import dev.latvian.mods.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.mods.kubejs.client.MenuScreenRegistryKubeEvent;
import dev.latvian.mods.kubejs.client.ParticleProviderRegistryKubeEvent;
import dev.latvian.mods.kubejs.fluid.FluidBlockBuilder;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.fluid.FluidTypeBuilder;
import dev.latvian.mods.kubejs.gui.KubeJSMenus;
import dev.latvian.mods.kubejs.gui.KubeJSScreen;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemModelPropertiesKubeEvent;
import dev.latvian.mods.kubejs.item.ModifyItemTooltipsKubeEvent;
import dev.latvian.mods.kubejs.kubedex.KubedexHighlight;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryObjectStorage;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import dev.latvian.mods.kubejs.web.WebServerProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="kubejs", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class KubeJSModClientEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void setupClient(FMLClientSetupEvent event) {
        KubeJS.PROXY = new KubeJSClient();
        event.enqueueWork(KubeJSModClientEventHandler::setupClient0);
    }

    @SubscribeEvent
    public static void addClientPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource((RepositorySource)new KubeJSResourcePackFinder());
        }
    }

    private static void setupClient0() {
        BuilderBase b;
        if (!PlatformWrapper.isGeneratingData() && Minecraft.getInstance() != null && WebServerProperties.get().enabled) {
            LocalWebServer.start(Minecraft.getInstance());
        }
        ItemEvents.MODEL_PROPERTIES.post(ScriptType.STARTUP, new ItemModelPropertiesKubeEvent());
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.BLOCK) {
            BlockRenderType blockRenderType;
            if (!(builderBase instanceof BlockBuilder)) continue;
            b = (BlockBuilder)builderBase;
            if (b instanceof FluidBlockBuilder) {
                FluidBlockBuilder fb = (FluidBlockBuilder)b;
                blockRenderType = fb.fluidBuilder.fluidType.renderType;
            } else {
                blockRenderType = ((BlockBuilder)b).renderType;
            }
            switch (blockRenderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.translucent());
                }
            }
        }
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.FLUID) {
            if (!(builderBase instanceof FluidBuilder)) continue;
            b = (FluidBuilder)builderBase;
            switch (((FluidBuilder)b).fluidType.renderType) {
                case CUTOUT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutout());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.cutoutMipped());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getSource(), (RenderType)RenderType.translucent());
                    ItemBlockRenderTypes.setRenderLayer((Fluid)((FlowingFluid)b.get()).getFlowing(), (RenderType)RenderType.translucent());
                }
            }
        }
        ArrayList list = new ArrayList();
        ItemEvents.MODIFY_TOOLTIPS.post(ScriptType.CLIENT, new ModifyItemTooltipsKubeEvent(list::add));
        KubeJSClient.clientItemTooltips = List.copyOf(list);
    }

    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        for (BuilderBase<Block> builderBase : RegistryObjectStorage.BLOCK) {
            if (!(builderBase instanceof BlockBuilder)) continue;
            BlockBuilder b = (BlockBuilder)builderBase;
            if (b.tint == null) continue;
            event.register((BlockColor)new BlockTintFunctionWrapper(b.tint), new Block[]{(Block)b.get()});
        }
    }

    @SubscribeEvent
    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        for (BuilderBase<Item> builderBase : RegistryObjectStorage.ITEM) {
            if (!(builderBase instanceof ItemBuilder)) continue;
            ItemBuilder b = (ItemBuilder)builderBase;
            if (b.tint == null) continue;
            event.register((ItemColor)new ItemTintFunctionWrapper(b.tint), new ItemLike[]{(ItemLike)b.get()});
        }
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(KubeJSMenus.MENU.get(), KubeJSScreen::new);
        ClientEvents.MENU_SCREEN_REGISTRY.post(ScriptType.STARTUP, new MenuScreenRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientEvents.ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new EntityRendererRegistryKubeEvent(event));
        ClientEvents.BLOCK_ENTITY_RENDERER_REGISTRY.post(ScriptType.STARTUP, new BlockEntityRendererRegistryKubeEvent(event));
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        KubedexHighlight.keyMapping = new KeyMapping("key.kubejs.kubedex", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputConstants.Type.KEYSYM, 75, "key.categories.kubejs");
        event.register(KubedexHighlight.keyMapping);
    }

    @SubscribeEvent
    public static void registerCoreShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ID.mc("kubejs/rendertype_highlight"), DefaultVertexFormat.POSITION_COLOR), s -> {
            KubedexHighlight.INSTANCE.highlightShader = s;
        });
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        for (BuilderBase<FluidType> builderBase : RegistryObjectStorage.FLUID_TYPE) {
            if (!(builderBase instanceof FluidTypeBuilder)) continue;
            final FluidTypeBuilder b = (FluidTypeBuilder)builderBase;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return b.actualStillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return b.actualFlowingTexture;
                }

                public ResourceLocation getOverlayTexture() {
                    return b.blockOverlayTexture;
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return b.screenOverlayTexture;
                }
            }, new FluidType[]{(FluidType)b.get()});
        }
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        if (ClientEvents.PARTICLE_PROVIDER_REGISTRY.hasListeners()) {
            ClientEvents.PARTICLE_PROVIDER_REGISTRY.post(new ParticleProviderRegistryKubeEvent(event));
        }
    }
}

