/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.JsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

@Info(value="Various item related helper methods")
public interface ItemWrapper {
    public static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    @Info(value="Returns an ItemStack of the input")
    public static ItemStack of(ItemStack in) {
        return in;
    }

    @Info(value="Returns an ItemStack of the input, with the specified count")
    public static ItemStack of(ItemStack in, int count) {
        return in.kjs$withCount(count);
    }

    @Info(value="Get a list of most items in the game. Items not in a creative tab are ignored")
    public static List<ItemStack> getList() {
        return ItemStackJS.getList();
    }

    @Info(value="Get a list of all the item ids in the game")
    public static List<String> getTypeList() {
        return ItemStackJS.getTypeList();
    }

    public static Map<ResourceLocation, Collection<ItemStack>> getTypeToStackMap() {
        return ItemStackJS.getTypeToStacks();
    }

    public static Collection<ItemStack> getVariants(ItemStack item) {
        return ItemWrapper.getTypeToStackMap().get(item.kjs$getIdLocation());
    }

    @Info(value="Get the item that represents air/an empty slot")
    public static ItemStack getEmpty() {
        return ItemStack.EMPTY;
    }

    @Info(value="Returns a Firework with the input properties")
    public static Fireworks fireworks(Fireworks fireworks) {
        return fireworks;
    }

    @Info(value="Gets an Item from an item id")
    public static Item getItem(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.get(id);
    }

    @Info(value="Gets an items id from the Item")
    public static ResourceLocation getId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Info(value="Checks if the provided item id exists in the registry")
    public static boolean exists(ResourceLocation id) {
        return BuiltInRegistries.ITEM.containsKey(id);
    }

    @Info(value="Checks if the passed in object is an ItemStack.\nNote that this does not mean it will not function as an ItemStack if passed to something that requests one.\n")
    public static boolean isItem(@Nullable Object o) {
        return o instanceof ItemStackJS;
    }

    public static ItemStack playerHead(String name) {
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of(name), Optional.empty(), new PropertyMap()));
        return stack;
    }

    public static ItemStack playerHeadFromBase64(UUID uuid, String textureBase64) {
        if (uuid == null || uuid.equals(Util.NIL_UUID)) {
            throw new IllegalArgumentException("UUID can't be null!");
        }
        if (textureBase64 == null || textureBase64.isBlank()) {
            throw new IllegalArgumentException("Texture Base 64 can't be empty!");
        }
        ItemStack stack = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        PropertyMap properties = new PropertyMap();
        properties.put((Object)"textures", (Object)new Property("textures", textureBase64));
        stack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.empty(), Optional.of(uuid), properties));
        return stack;
    }

    public static ItemStack playerHeadFromUrl(String url) {
        JsonObject root = new JsonObject();
        JsonObject textures = new JsonObject();
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        textures.add("SKIN", (JsonElement)skin);
        root.add("textures", (JsonElement)textures);
        byte[] bytes = JsonUtils.toString((JsonElement)root).getBytes(StandardCharsets.UTF_8);
        return ItemWrapper.playerHeadFromBase64(UUID.nameUUIDFromBytes(bytes), Base64.getEncoder().encodeToString(bytes));
    }

    public static ItemStack playerHeadFromSkinHash(String hash) {
        return ItemWrapper.playerHeadFromUrl("https://textures.minecraft.net/texture/" + hash);
    }

    public static ItemAbility itemAbilityOf(Object object) {
        if (object instanceof ItemAbility) {
            ItemAbility ta = (ItemAbility)object;
            return ta;
        }
        if (object != null) {
            return ItemAbility.get((String)object.toString());
        }
        return null;
    }
}

