/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.AirPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ArmorPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.HealthPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ToughnessPlaqueRenderer;
import fuzs.mobplaques.client.helper.EntityVisibilityHelper;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public class MobPlaqueHandler {
    private static final int PLAQUE_HORIZONTAL_DISTANCE = 2;
    private static final int PLAQUE_VERTICAL_DISTANCE = 2;
    public static final Map<ResourceLocation, MobPlaqueRenderer> PLAQUE_RENDERERS = new LinkedHashMap<ResourceLocation, MobPlaqueRenderer>();

    public static EventResult onRenderNameTag(Entity entity, DefaultedValue<Component> content, EntityRenderer<?> entityRenderer, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float partialTick) {
        LivingEntity livingEntity;
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return EventResult.PASS;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive() && ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).isEntityAllowed(livingEntity)) {
            Minecraft minecraft = Minecraft.getInstance();
            EntityRenderDispatcher dispatcher = entityRenderer.entityRenderDispatcher;
            Vec3 vec3 = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getViewYRot(partialTick));
            if (vec3 != null && dispatcher.camera != null && dispatcher.camera.getEntity() instanceof LivingEntity && EntityVisibilityHelper.isEntityVisible((Level)minecraft.level, livingEntity, (Player)minecraft.player, partialTick, dispatcher)) {
                poseStack.pushPose();
                poseStack.translate(vec3.x, vec3.y + 0.5, vec3.z);
                poseStack.mulPose(dispatcher.cameraOrientation());
                float plaqueScale = MobPlaqueHandler.getPlaqueScale(livingEntity, dispatcher, (Player)minecraft.player);
                poseStack.scale(0.025f * plaqueScale, -0.025f * plaqueScale, -0.025f * plaqueScale);
                int heightOffset = MobPlaqueHandler.computeHeightOffset(livingEntity, (Component)content.get(), plaqueScale, minecraft.font);
                MobPlaqueHandler.renderAllPlaques(livingEntity, poseStack, multiBufferSource, packedLight, heightOffset, minecraft.font);
                poseStack.popPose();
            }
        }
        return EventResult.PASS;
    }

    private static int computeHeightOffset(LivingEntity livingEntity, Component nameComponent, float plaqueScale, Font font) {
        int heightOffset = "deadmau5".equals(nameComponent.getString()) ? -13 : -3;
        heightOffset -= (int)((float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).offsetHeight * (0.5f / plaqueScale));
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBelowNameTag) {
            heightOffset += (int)(23.0f * (0.5f / plaqueScale));
        } else {
            int plaquesHeight = MobPlaqueHandler.getPlaquesHeight(font, livingEntity);
            heightOffset -= (int)((float)(plaquesHeight + 2) * (0.5f / plaqueScale));
        }
        return heightOffset;
    }

    private static void renderAllPlaques(LivingEntity livingEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int heightOffset, Font font) {
        Iterator<MobPlaqueRenderer> iterator = PLAQUE_RENDERERS.values().iterator();
        List<MutableInt> widths = MobPlaqueHandler.getPlaquesWidths(font, livingEntity);
        for (MutableInt width : widths) {
            int rowStart = -width.intValue() / 2;
            int maxRowHeight = 0;
            while (iterator.hasNext()) {
                MobPlaqueRenderer plaqueRenderer = iterator.next();
                if (!plaqueRenderer.wantsToRender(livingEntity)) continue;
                int plaqueWidth = plaqueRenderer.getWidth(font, livingEntity);
                plaqueRenderer.render(poseStack, multiBufferSource, packedLight, rowStart + plaqueWidth / 2, heightOffset, font, livingEntity);
                maxRowHeight = Math.max(plaqueRenderer.getHeight(), maxRowHeight);
                rowStart += (plaqueWidth += 2);
                if (width.addAndGet(-plaqueWidth) > 0) continue;
                break;
            }
            heightOffset += maxRowHeight + 2;
        }
    }

    private static float getPlaqueScale(LivingEntity targetEntity, EntityRenderDispatcher dispatcher, Player player) {
        float plaqueScale = (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueScale;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).scaleWithDistance) {
            double distanceSqr = dispatcher.distanceToSqr((Entity)targetEntity);
            double entityInteractionRange = player.entityInteractionRange();
            double scaleRatio = Mth.clamp((double)((distanceSqr - Math.pow(entityInteractionRange / 2.0, 2.0)) / (Math.pow(entityInteractionRange * 2.0, 2.0) / 2.0)), (double)0.0, (double)2.0);
            plaqueScale *= (float)(1.0 + scaleRatio);
        }
        return plaqueScale;
    }

    private static List<MutableInt> getPlaquesWidths(Font font, LivingEntity entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        ArrayList widths = Lists.newArrayList();
        int index = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (widths.isEmpty() || maxWidth < ((MutableInt)widths.get(index)).intValue() + 2 + plaqueWidth) {
                widths.add(new MutableInt(plaqueWidth));
                ++index;
                continue;
            }
            ((MutableInt)widths.get(index)).add(2 + plaqueWidth);
        }
        return widths;
    }

    private static int getPlaquesHeight(Font font, LivingEntity entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        int currentWidth = -1;
        int currentMaxHeight = 0;
        int totalHeight = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (currentWidth == -1 || maxWidth < currentWidth + 2 + plaqueWidth) {
                currentWidth = plaqueWidth;
                currentMaxHeight = plaqueRenderer.getHeight();
                totalHeight += plaqueRenderer.getHeight() + (totalHeight == -1 ? 0 : 2);
                continue;
            }
            currentWidth += 2 + plaqueWidth;
            if (plaqueRenderer.getHeight() <= currentMaxHeight) continue;
            totalHeight += plaqueRenderer.getHeight() - currentMaxHeight;
            currentMaxHeight = plaqueRenderer.getHeight();
        }
        return totalHeight;
    }

    static {
        PLAQUE_RENDERERS.put(MobPlaques.id("health"), new HealthPlaqueRenderer());
        PLAQUE_RENDERERS.put(MobPlaques.id("air"), new AirPlaqueRenderer());
        PLAQUE_RENDERERS.put(MobPlaques.id("armor"), new ArmorPlaqueRenderer());
        PLAQUE_RENDERERS.put(MobPlaques.id("toughness"), new ToughnessPlaqueRenderer());
    }
}

