/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class TransitionPlaqueRenderer
extends MobPlaqueRenderer {
    private final int defaultHighColor;
    private final int defaultLowColor;
    private boolean shiftColors;
    private PlaqueValue plaqueValue;

    protected TransitionPlaqueRenderer(int defaultHighColor, int defaultLowColor) {
        this.defaultHighColor = defaultHighColor;
        this.defaultLowColor = defaultLowColor;
    }

    public abstract int getMaxValue(LivingEntity var1);

    protected boolean belowMaxValue(LivingEntity entity) {
        return this.getValue(entity) < this.getMaxValue(entity);
    }

    @Override
    protected Component getComponent(LivingEntity entity) {
        return switch (this.plaqueValue.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> super.getComponent(entity);
            case 1 -> Component.literal((String)(this.getValue(entity) + "/" + this.getMaxValue(entity)));
            case 2 -> Component.literal((String)((int)(this.getValuePercentage(entity) * 100.0f) + "%"));
        };
    }

    @Override
    protected int getColor(LivingEntity entity) {
        if (!this.shiftColors) {
            return super.getColor(entity);
        }
        float transition = this.getValuePercentage(entity);
        return TransitionPlaqueRenderer.packTransitionedColor(this.defaultHighColor, this.defaultLowColor, transition);
    }

    private float getValuePercentage(LivingEntity entity) {
        return Mth.clamp((float)((float)this.getValue(entity) / (float)this.getMaxValue(entity)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setupConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        super.setupConfig(builder, callback);
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Transition text colors depending on current percentage.").define("shift_colors", false), v -> {
            this.shiftColors = v;
        });
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Show current amount either as percentage or as absolute value.").defineEnum("plaque_value", (Enum)PlaqueValue.RELATIVE), v -> {
            this.plaqueValue = v;
        });
    }

    public static int packTransitionedColor(int startColor, int endColor, float transition) {
        int startR = FastColor.ARGB32.red((int)startColor);
        int startG = FastColor.ARGB32.green((int)startColor);
        int startB = FastColor.ARGB32.blue((int)startColor);
        int endR = FastColor.ARGB32.red((int)endColor);
        int endG = FastColor.ARGB32.green((int)endColor);
        int endB = FastColor.ARGB32.blue((int)endColor);
        int colorR = endR + (int)((float)(startR - endR) * transition);
        int colorG = endG + (int)((float)(startG - endG) * transition);
        int colorB = endB + (int)((float)(startB - endB) * transition);
        return FastColor.ARGB32.color((int)0, (int)colorR, (int)colorG, (int)colorB);
    }

    private static enum PlaqueValue {
        ABSOLUTE,
        ABSOLUTE_WITH_MAX,
        RELATIVE;

    }
}

