/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.helper.GuiBlitHelper;
import fuzs.mobplaques.client.renderer.ModRenderType;
import fuzs.mobplaques.config.ClientConfig;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.joml.Matrix4f;

public abstract class MobPlaqueRenderer {
    protected static final int PLAQUE_HEIGHT = 11;
    protected static final int BACKGROUND_BORDER_SIZE = 1;
    protected static final int ICON_SIZE = 9;
    protected static final int TEXT_ICON_GAP = 2;
    protected boolean allowRendering;

    public boolean wantsToRender(LivingEntity entity) {
        return this.allowRendering && this.getValue(entity) > 0;
    }

    public int getWidth(Font font, LivingEntity entity) {
        return font.width((FormattedText)this.getComponent(entity)) + 2 + 9 + 2;
    }

    public int getHeight() {
        return 11;
    }

    public abstract int getValue(LivingEntity var1);

    protected Component getComponent(LivingEntity entity) {
        return Component.literal((String)(this.getValue(entity) + "x"));
    }

    protected int getColor(LivingEntity entity) {
        return 0xFFFFFF;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int posX, int posY, Font font, LivingEntity entity) {
        poseStack.pushPose();
        this.renderBackground(poseStack, posX, posY, bufferSource, packedLight, font, entity);
        this.renderComponent(poseStack, posX, posY, bufferSource, packedLight, font, entity);
        this.renderIcon(poseStack, bufferSource, packedLight, posX, posY, font, entity);
        poseStack.popPose();
    }

    private void renderBackground(PoseStack poseStack, int posX, int posY, MultiBufferSource bufferSource, int packedLight, Font font, LivingEntity entity) {
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBackground) {
            int totalWidth = this.getWidth(font, entity);
            int backgroundColor = Minecraft.getInstance().options.getBackgroundColor(0.25f);
            GuiBlitHelper.fill(poseStack, bufferSource, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : packedLight, posX - totalWidth / 2, posY, posX + totalWidth / 2, posY + this.getHeight(), 0.03f, backgroundColor);
        }
    }

    private void renderComponent(PoseStack poseStack, int posX, int posY, MultiBufferSource bufferSource, int packedLight, Font font, LivingEntity entity) {
        Component component = this.getComponent(entity);
        int totalWidth = this.getWidth(font, entity);
        Matrix4f matrix4f = poseStack.last().pose();
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            font.drawInBatch(component, (float)posX - (float)totalWidth / 2.0f + 1.0f, (float)(posY + 1 + 1), FastColor.ARGB32.color((int)32, (int)this.getColor(entity)), false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, 0, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : packedLight);
        }
        font.drawInBatch(component, (float)posX - (float)totalWidth / 2.0f + 1.0f, (float)(posY + 1 + 1), FastColor.ARGB32.color((int)255, (int)this.getColor(entity)), false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : packedLight);
    }

    private void renderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int posX, int posY, Font font, LivingEntity entity) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderIconBackground(poseStack, bufferSource, packedLight, posX += this.getWidth(font, entity) / 2 - 1 - 9, ++posY, entity);
        this.innerRenderIcon(poseStack, bufferSource, packedLight, posX, posY, 0.0f, this.getSprite(entity));
    }

    protected void innerRenderIcon(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int posX, int posY, float zOffset, ResourceLocation resourceLocation) {
        TextureAtlasSprite textureAtlasSprite = Minecraft.getInstance().getGuiSprites().getSprite(resourceLocation);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(ModRenderType.ICON_SEE_THROUGH.apply(textureAtlasSprite.atlasLocation()));
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            GuiBlitHelper.blitSprite(poseStack, vertexConsumer, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : packedLight, posX, posY, zOffset, textureAtlasSprite, 9, 9, FastColor.ARGB32.color((int)32, (int)-1));
        }
        vertexConsumer = bufferSource.getBuffer(ModRenderType.ICON.apply(textureAtlasSprite.atlasLocation()));
        GuiBlitHelper.blitSprite(poseStack, vertexConsumer, ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).fullBrightness ? 0xF000F0 : packedLight, posX, posY, zOffset, textureAtlasSprite, 9, 9, -1);
    }

    protected void renderIconBackground(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int posX, int posY, LivingEntity entity) {
    }

    protected abstract ResourceLocation getSprite(LivingEntity var1);

    public void setupConfig(ModConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ModConfigSpec.ConfigValue)builder.comment("Allow for rendering this type of plaque.").define("allow_rendering", true), v -> {
            this.allowRendering = v;
        });
    }
}

